<!DOCTYPE html>
<html lang="en" class="light">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
		<link href="" rel="shortcut icon">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="shortcut icon" type="image/x-icon" href="/assets/images/logo2.png">

        <title>Login - MMS Portal</title>

		<!-- BEGIN: CSS Assets-->
		<link rel="stylesheet" href="<?php echo e(URL::asset('assets/css/login.css')); ?>">
		<!-- END: CSS Assets-->
		<style>
			form#login_validator {
				margin-top: 15%;
			}
			
		</style>
	</head>
    <body class="login">

	
        <div class="container sm:px-10">
			<div class="block xl:grid grid-cols-2 gap-4">
				<!-- BEGIN: Login Info -->
				<div class="hidden xl:flex flex-col min-h-screen">
					<a href="#" class="-intro-x flex items-center pt-5">
						<img alt="Logo" class="" width="150px" src="<?php echo e(URL::asset('assets/images/logo2.png')); ?>">
					</a>
					<div class="my-auto">
						<img alt="Midone - HTML Admin Template" class="-intro-x w-1/2 -mt-16" src="<?php echo e(URL::asset('assets/images/illustration.svg')); ?>">
						<div class="-intro-x text-white font-medium text-4xl leading-tight mt-10">Online Human Resource Management Portal</div>
						<div class="-intro-x mt-5 text-lg text-white text-opacity-70 dark:text-slate-400">Manage All Your Employee Engagement,<br>Time Management,Work Reports</div>
					</div>
				</div>
				<!-- END: Login Info -->
				<!-- BEGIN: Login Form -->
				<form action="<?php echo e(url('/loginaction')); ?>" id="login_validator" method="post" class="login_validator">
                    <?php echo csrf_field(); ?>
					<div class="h-screen xl:h-auto flex py-5 xl:py-0 my-10 xl:my-0">
						<div class="my-auto mx-auto xl:ml-20 bg-white dark:bg-darkmode-600 xl:bg-transparent px-5 sm:px-8 py-8 xl:p-0 rounded-md shadow-md xl:shadow-none w-full sm:w-3/4 lg:w-2/4 xl:w-auto">
							<h2 class="intro-x font-bold text-2xl xl:text-3xl text-center xl:text-left">Sign In</h2>
							<div class="intro-x mt-2 text-slate-400 xl:hidden text-center">A few more clicks to sign in to your account. Manage all your e-commerce accounts in one place</div>
							<div class="intro-x mt-8">
								<input type="text" class="intro-x login__input form-control py-3 px-4 block" placeholder="User ID" name="emp_cd">
								<input type="password" class="intro-x login__input form-control py-3 px-4 block mt-4" placeholder="Password" name="password">
							</div>
							<div class="intro-x flex text-slate-600 dark:text-slate-500 text-xs sm:text-sm mt-4">
								<div class="flex items-center mr-auto">
									<input id="remember-me" type="checkbox" class="form-check-input border mr-2">
									<label class="cursor-pointer select-none" for="remember-me">Remember me</label>
								</div>
								<a href="<?php echo e(url('/forget-password')); ?>">Forgot Password?</a>
							</div>
							<div class="intro-x mt-5 xl:mt-8 text-center xl:text-left">
								<button class="btn btn-primary py-3 px-4 w-full xl:w-32 xl:mr-3 align-top" type="submit">Login</button>
							</div>
							<span style="color: red;"><?php echo Session::get('flash_error'); ?></span>
							<!--<div class="intro-x mt-10 xl:mt-24 text-slate-600 dark:text-slate-500 text-center xl:text-left">
								By signin up, you agree to our <a class="text-primary dark:text-slate-200" href="#">Terms and Conditions</a> &amp; <a class="text-primary dark:text-slate-200" href="#">Privacy Policy</a>
							</div>-->
						</div>
					</div>
				</form>
				<!-- END: Login Form -->
			</div>
		</div>
	</body>
</html><?php /**PATH /home/trisquare/resources/views/login.blade.php ENDPATH**/ ?>