<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\hrm\TimeSheetController;
use App\Http\Controllers\hrm\MissPunchController;
use App\Http\Controllers\hrm\LeaveApprovalController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Test
Route::get('/testoracle', 'App\Http\Controllers\api\AttendanceController@testoracle');

Route::get('/', 'App\Http\Controllers\TermsController@login');
Route::get('/login', 'App\Http\Controllers\TermsController@login')->name('login');
Route::get('/forget-password', 'App\Http\Controllers\ForgetPasswordController@forget');
Route::get('/success_message', 'App\Http\Controllers\ForgetPasswordController@verify');
Route::post('/forget-password', 'App\Http\Controllers\ForgetPasswordController@postEmail');
Route::get('/reset-password/{token}', 'App\Http\Controllers\ForgetPasswordController@reset');
Route::post('/reset-password/save', 'App\Http\Controllers\ForgetPasswordController@updatePassword');
Route::post('/loginaction', 'App\Http\Controllers\TermsController@loginAction');
Route::get('/logout', 'App\Http\Controllers\TermsController@logout');

Route::group(['middleware' => 'checklogin'], function($router) {

    Route::get('/dashboard', 'App\Http\Controllers\TermsController@dashboard');
    Route::get('/change-password', 'App\Http\Controllers\TermsController@changePassword');
    Route::post('/change-password/save', 'App\Http\Controllers\TermsController@saveChangePassword');
    Route::post('/sendWish', 'App\Http\Controllers\TermsController@sendWishes');
    Route::post('/sendAnniversaryWish', 'App\Http\Controllers\TermsController@sendAnniversaryWish');
    Route::get('/allbirthdayemp', 'App\Http\Controllers\TermsController@allBirthdayEmp');
    Route::get('/allworkanniemp', 'App\Http\Controllers\TermsController@allWorkAnniversaryEmp');
    Route::get('/allnewemp', 'App\Http\Controllers\TermsController@allNewEmp');
    Route::get('/checkin', 'App\Http\Controllers\hrm\CheckinCheckoutController@CheckInSection');
    Route::post('/checkin/save-checkin', 'App\Http\Controllers\hrm\CheckinCheckoutController@attendanceCheckIn');
    Route::post('/checkin/save-checkout', 'App\Http\Controllers\hrm\CheckinCheckoutController@attendanceCheckOut');
    Route::get('/view-attendance', 'App\Http\Controllers\hrm\CheckinCheckoutController@viewAttendance');
    Route::post('/view-attendance', 'App\Http\Controllers\hrm\CheckinCheckoutController@searchAttendance');
    Route::get('/view-team-att', 'App\Http\Controllers\hrm\CheckinCheckoutController@viewTeamAttendance');
    Route::post('/view-team-att', 'App\Http\Controllers\hrm\CheckinCheckoutController@searchTeamAttendance');

    Route::get('/leave-approval', [LeaveApprovalController::class, 'index']);
    Route::post('/leave-approval/approved', [LeaveApprovalController::class, 'leaveApproved']);
    Route::get('/leave-history', [LeaveApprovalController::class, 'viewLeaveHistory']);
    Route::post('/leave-history', [LeaveApprovalController::class, 'searchViewLeaveHistory']);
    Route::post('/leave-history/export', [LeaveApprovalController::class, 'export']);
    Route::get('/leave-summery', [LeaveApprovalController::class, 'leaveSummery']);
    Route::get('/att-perform', [LeaveApprovalController::class, 'attPerform']);

    Route::get('/view-team-att/export', 'App\Http\Controllers\hrm\CheckinCheckoutController@exportRecord');

    Route::get('/view-attendance/export', 'App\Http\Controllers\hrm\CheckinCheckoutController@exportMyRecord');
    Route::post('/checkin/set-location', 'App\Http\Controllers\hrm\CheckinCheckoutController@setLocation');


    Route::post('/checkin/saveMissPunchData', 'App\Http\Controllers\hrm\CheckinCheckoutController@saveMissPunchData');
    Route::post('/checkin/getApproved', 'App\Http\Controllers\hrm\CheckinCheckoutController@getApproved');
    Route::post('/checkin/getReject', 'App\Http\Controllers\hrm\CheckinCheckoutController@getReject');

    Route::get('/view-all-att', 'App\Http\Controllers\hrm\CheckinCheckoutController@viewAllTeamAttendance');
    Route::get('/view-all-att/search', 'App\Http\Controllers\hrm\CheckinCheckoutController@searchAllTeamAttendance');
    Route::post('/view-all-att/setEmpCodeData', 'App\Http\Controllers\hrm\CheckinCheckoutController@setEmpCodeData');
    Route::get('/view-all-att/export', 'App\Http\Controllers\hrm\CheckinCheckoutController@exportAllRecord');

    // MissPunch Route
    Route::get('/miss-punch', [MissPunchController::class, 'index']);
    Route::post('/miss-punch/saveMissPunchData', [MissPunchController::class, 'saveMissPunchData']);
    Route::get('/miss-punch/excel-export', [MissPunchController::class, 'excelExport']);
    Route::get('/miss-punch/pdf-export', [MissPunchController::class, 'pdfExport']);

    // Apporval Request Route
    Route::get('/approval-request', 'App\Http\Controllers\hrm\ApprovalRequestController@index');
    Route::post('/approval-request/getApproved', 'App\Http\Controllers\hrm\ApprovalRequestController@getApproved');
    Route::post('/approval-request/getReject', 'App\Http\Controllers\hrm\ApprovalRequestController@getReject');
    Route::get('/approval-request/excel-export', 'App\Http\Controllers\hrm\ApprovalRequestController@excelExport');
    Route::get('/approval-request/pdf-export', 'App\Http\Controllers\hrm\ApprovalRequestController@pdfExport');

    //mispunch-attendance-update form
    Route::get('/mispunch-attendance-update', 'App\Http\Controllers\hrm\ApprovalRequestController@mispunchAttendanceUpdate');
    Route::post('/mispunch-attendance-update/save', 'App\Http\Controllers\hrm\ApprovalRequestController@mispunchAttendanceUpdateSave');

    // Leave Request Route
    Route::get('/leave-request', 'App\Http\Controllers\hrm\LeaveRequestController@index');
    Route::get('/leave-request/pending-approval', 'App\Http\Controllers\hrm\LeaveRequestController@pendingApproval');
    Route::get('/leave-request/pending-other-approval', 'App\Http\Controllers\hrm\LeaveRequestController@pendingOtherApproval');

    Route::post('/leave-request/leaveSave', 'App\Http\Controllers\hrm\LeaveRequestController@leaveSave');
    Route::post('/leave-request/leaveUpdate', 'App\Http\Controllers\hrm\LeaveRequestController@leaveUpdate');
    Route::post('/leave-request/leaveCancel', 'App\Http\Controllers\hrm\LeaveRequestController@leaveCancel');
    Route::post('/leave-request/checkLeaveBalance', 'App\Http\Controllers\hrm\LeaveRequestController@checkLeaveBalance');
    Route::post('/leave-request/getLeaveApplyBehalfEmp', 'App\Http\Controllers\hrm\LeaveRequestController@getLeaveApplyBehalfEmp');

    // Work From Home (Kunal)
    Route::get('/workfromhome', 'App\Http\Controllers\hrm\WFHRequestController@index');
    Route::get('/workfromhome/history', 'App\Http\Controllers\hrm\WFHRequestController@indexHistory');
    Route::post('/workfromhome/wfhSave', 'App\Http\Controllers\hrm\WFHRequestController@wfhSave');
    Route::post('/workfromhome/wfhCancel', 'App\Http\Controllers\hrm\WFHRequestController@wfhCancel');
    Route::post('/workfromhome/approved', 'App\Http\Controllers\hrm\WFHRequestController@wfhApproved');

    // Outdoor duty (Kunal)
    Route::get('/outdoorduty', 'App\Http\Controllers\hrm\ODRequestController@index');
    Route::get('/outdoorduty/history', 'App\Http\Controllers\hrm\ODRequestController@indexHistory');
    Route::post('/outdoorduty/odSave', 'App\Http\Controllers\hrm\ODRequestController@odSave');
    Route::post('/outdoorduty/odCancel', 'App\Http\Controllers\hrm\ODRequestController@odCancel');
    Route::post('/outdoorduty/approved', 'App\Http\Controllers\hrm\ODRequestController@odApproved');
    Route::post('/outdoorduty/getShift', 'App\Http\Controllers\hrm\ODRequestController@getShift');

    // Suggesion
    Route::post('/suggesion', 'App\Http\Controllers\TermsController@Suggesion');

    // Employee Master By Suraj 
    Route::get('/all-employees', 'App\Http\Controllers\hrm\EmpMasterController@index');
    Route::post('/all-employees', 'App\Http\Controllers\hrm\EmpMasterController@searchViewEmpMaster');
    Route::get('/add-new-amp', 'App\Http\Controllers\hrm\EmpMasterController@create');
    Route::post('/all-employees/save', 'App\Http\Controllers\hrm\EmpMasterController@empSave');
    Route::get('/add-new-amp/view/{id}', 'App\Http\Controllers\hrm\EmpMasterController@empShow');
    Route::get('/add-new-amp/update/{id}', 'App\Http\Controllers\hrm\EmpMasterController@empUpdatePage');
    Route::post('/all-employees/update/save', 'App\Http\Controllers\hrm\EmpMasterController@empUpdate');
    Route::post('/all-employees/gen-card-no', 'App\Http\Controllers\hrm\EmpMasterController@genCardNo');
    Route::get('/all-employees/excel-export', 'App\Http\Controllers\hrm\EmpMasterController@excelExport');

    // User Master By Suraj 
    Route::get('/user-master', 'App\Http\Controllers\hrm\UserMasterController@index');
    Route::post('/user-master', 'App\Http\Controllers\hrm\UserMasterController@searchViewUserMaster');
    Route::get('/add-new-user', 'App\Http\Controllers\hrm\UserMasterController@create');
    Route::post('/user-master/save', 'App\Http\Controllers\hrm\UserMasterController@userSave');
    Route::get('/user-master/update/{id}', 'App\Http\Controllers\hrm\UserMasterController@userUpdatePage');
    Route::post('/user-master/update/save', 'App\Http\Controllers\hrm\UserMasterController@userUpdate');
    // Route::get('/user-master/excel-export', 'App\Http\Controllers\hrm\UserMasterController@excelExport');

    // Imprest Claim By SUraj
    Route::get('/imprest-claim', 'App\Http\Controllers\hrm\ImprestClaimController@index');
    Route::get('/add-new-claim', 'App\Http\Controllers\hrm\ImprestClaimController@create');
    Route::post('/imprest-claim/save', 'App\Http\Controllers\hrm\ImprestClaimController@saveClaim');
    Route::post('/imprest-claim/Cancel', 'App\Http\Controllers\hrm\ImprestClaimController@cancel');
    Route::post('/imprest-claim/approved', 'App\Http\Controllers\hrm\ImprestClaimController@approved');

    // File Master (Kunal)
    Route::get('/file-master','App\Http\Controllers\hrm\FileMasterController@index');
    Route::get('/add-file','App\Http\Controllers\hrm\FileMasterController@create');
    Route::post('/file-master/save','App\Http\Controllers\hrm\FileMasterController@fileSave');
    Route::get('/update-file/{id}','App\Http\Controllers\hrm\FileMasterController@UpdateFile');
    Route::post('/file-master/update','App\Http\Controllers\hrm\FileMasterController@fileUpdate');

    // My-Miss Punch Details
    Route::get('/my-miss-punch-details','App\Http\Controllers\hrm\MissPunchController@missPunchDetail');

    Route::get('/my-miss-punch-details-xl','App\Http\Controllers\hrm\MissPunchController@excelExportmymisspunch');
    // Route::get('/my-miss-punch-details/excel-export', 'App\Http\Controllers\hrm\MissPunchController@excelExportsss');

    // User Priv
    Route::get('/user-prev','App\Http\Controllers\hrm\UserPrevController@index');
    Route::get('/user-prev/create','App\Http\Controllers\hrm\UserPrevController@create');
    Route::post('/user-prev/save','App\Http\Controllers\hrm\UserPrevController@save');
    Route::get('/user-prev/edit/{id}','App\Http\Controllers\hrm\UserPrevController@edit');
    Route::post('/user-prev/update','App\Http\Controllers\hrm\UserPrevController@update');
    Route::post('/user-prev/data-list-user','App\Http\Controllers\hrm\UserPrevController@userData');

    // Employee leave master (Kunal)
    Route::get('/employee-leave-master','App\Http\Controllers\hrm\EmployeeLeaveMasterController@index');
    Route::get('/add-emp-leave','App\Http\Controllers\hrm\EmployeeLeaveMasterController@create');
    Route::post('/employee-leave-master/save','App\Http\Controllers\hrm\EmployeeLeaveMasterController@fileSave');
    Route::get('/update-emp-leave/{id}','App\Http\Controllers\hrm\EmployeeLeaveMasterController@UpdateFile');
    Route::post('/employee-leave-master/update','App\Http\Controllers\hrm\EmployeeLeaveMasterController@fileUpdate');


    // Reuest For Extra Working Hour duty (Shivam)
    Route::get('/rquest-extra-working-hr', 'App\Http\Controllers\hrm\RequestForExtraWorkingHrController@index');
    Route::get('/rquest-extra-working-hr/history', 'App\Http\Controllers\hrm\RequestForExtraWorkingHrController@indexHistory');
    Route::get('/rquest-extra-working-hr/pending-approval', 'App\Http\Controllers\hrm\RequestForExtraWorkingHrController@pendingApproval');
    Route::post('/rquest-extra-working-hr/Save', 'App\Http\Controllers\hrm\RequestForExtraWorkingHrController@save');
    Route::post('/rquest-extra-working-hr/Cancel', 'App\Http\Controllers\hrm\RequestForExtraWorkingHrController@cancel');
    Route::post('/rquest-extra-working-hr/approved', 'App\Http\Controllers\hrm\RequestForExtraWorkingHrController@approved');
    Route::post('/rquest-extra-working-hr/check_start_end_time', 'App\Http\Controllers\hrm\RequestForExtraWorkingHrController@check_start_end_time');

    Route::get('/employee-leave-master', 'App\Http\Controllers\hrm\EmployeeLeaveMasterController@index');
    Route::post('/employee-leave-master/empleaveSave', 'App\Http\Controllers\hrm\EmployeeLeaveMasterController@empleaveSave');
    Route::post('employee-leave-master/EditLeave', 'App\Http\Controllers\hrm\EmployeeLeaveMasterController@editLeave');
    Route::post('/employee-leave-master/append', 'App\Http\Controllers\hrm\EmployeeLeaveMasterController@empLeaveAppend');
    Route::post('/employee-leave-master/empleaveUpdate', 'App\Http\Controllers\hrm\EmployeeLeaveMasterController@empleaveUpdate');
    Route::post('/employee-leave-master/gettabledata', 'App\Http\Controllers\hrm\EmployeeLeaveMasterController@getTableData');


    Route::get('/emailCheck','App\Http\Controllers\hrm\LeaveRequestController@emailCheck');


    //Pay Slip(Kunal)
    Route::get('/payslip', 'App\Http\Controllers\hrm\PaySlipController@index');
    Route::post('/payslip/downloadpdf', 'App\Http\Controllers\hrm\PaySlipController@getpdf');
    Route::post('/payslip/getpayslipdata', 'App\Http\Controllers\hrm\PaySlipController@getPayslipData');
    Route::post('/payslip/getEmpData', 'App\Http\Controllers\hrm\PaySlipController@getEmployeeData');

    //email log
    Route::get('/email-log','App\Http\Controllers\hrm\EmailLogController@index');

    //favorite(Kunal)
    Route::post('/favorite', 'App\Http\Controllers\hrm\FavoriteController@saveFav');

    // Deletefav(Kunal)
    Route::post('/deletefav', 'App\Http\Controllers\TermsController@DeletefavPage');

    //favorite(Kunal)
    Route::post('/favorite_check','App\Http\Controllers\hrm\FavoriteController@FavoriteCheck');

    //ChatBox(Kunal)
    Route::get('/chatboxindex', 'App\Http\Controllers\hrm\ChatBoxController@chatBoxIndex');
    Route::post('/user_chat_save', 'App\Http\Controllers\hrm\ChatBoxController@ChatSave');
    Route::post('/getUserChat', 'App\Http\Controllers\hrm\ChatBoxController@getUserChats');
    Route::post('/get_new_chat_update', 'App\Http\Controllers\hrm\ChatBoxController@getNewChatUpdate');
    Route::post('/search_chat', 'App\Http\Controllers\hrm\ChatBoxController@searchChat');
    Route::post('/count_noti', 'App\Http\Controllers\hrm\ChatBoxController@countNotification');
    Route::post('/getEmpforchat', 'App\Http\Controllers\hrm\ChatBoxController@getEmployees');
    Route::post('/update_sep_count', 'App\Http\Controllers\hrm\ChatBoxController@UpdateEmpSeperateCount');
    Route::post('/update_seen_unseen', 'App\Http\Controllers\hrm\ChatBoxController@UpdateSeenUnseen');


    //Time-Sheet

    Route::get('/time-sheet-list', [TimeSheetController::class, 'index']);
    Route::get('/time-sheet-list/create', [TimeSheetController::class, 'create']);
    Route::get('/time-sheet-list/edit-temp/{id}', [TimeSheetController::class, 'editTemp']);
    Route::post('/time-sheet-list/checkTimeSheetValidation', [TimeSheetController::class, 'checkTimeSheetValidation']);
    Route::post('/time-sheet-list/getClientData', [TimeSheetController::class, 'getClientData']);
    Route::post('/time-sheet-list/getInTimeOutTimeCal', [TimeSheetController::class, 'getInTimeOutTimeCal']);
    Route::post('/time-sheet-list/save', [TimeSheetController::class, 'save']);
    Route::post('/time-sheet-list/saveFinal', [TimeSheetController::class, 'saveFinal']);
    Route::post('/time-sheet-list/saveTemp', [TimeSheetController::class, 'saveTemp']);
    Route::post('/time-sheet-list/sumTimeTaken', [TimeSheetController::class, 'sumTimeTaken']);


    //NoticeBoard
    Route::get('/notice-board','App\Http\Controllers\hrm\NoticeBordController@index');
    Route::post('/notice-board', 'App\Http\Controllers\hrm\NoticeBordController@searchViewNoticeBoard');
    Route::get('/create', 'App\Http\Controllers\hrm\NoticeBordController@create');
    Route::post('/notice-board/save', 'App\Http\Controllers\hrm\NoticeBordController@noticeBoardSave');

    Route::get('/notice-board/update/{id}', 'App\Http\Controllers\hrm\NoticeBordController@UpdatePage');

    Route::get('/notice-board/checkbox/update', 'App\Http\Controllers\hrm\NoticeBordController@UpdatecheckboxUpdate');

    Route::post('/notice-board/update/save', 'App\Http\Controllers\hrm\NoticeBordController@Update');

    Route::post('/descmax', 'App\Http\Controllers\TermsController@DescMax');
    Route::get('/notice-board/view/{id}', 'App\Http\Controllers\hrm\NoticeBordController@view');
    Route::get('/notice-board/viewAll', 'App\Http\Controllers\hrm\NoticeBordController@viewAll');
    Route::post('/notice-board/removenoti', 'App\Http\Controllers\hrm\NoticeBordController@removeNoti');
    Route::get('/header', 'App\Http\Controllers\hrm\NoticeBordController@header');
    Route::post('/locimgwarninglist', 'App\Http\Controllers\hrm\CheckinCheckoutController@LocImgWarnList');

    // Saturday Leave Master By Ashish Kumar
    Route::get('/saturday-leave', 'App\Http\Controllers\hrm\SaturdayLeaveController@saturdayLeaveIndex');
    Route::post('/saturday-leave-details/search', 'App\Http\Controllers\hrm\SaturdayLeaveController@saturdayLeaveSearch');
    Route::get('/saturday-leave-details/update', 'App\Http\Controllers\hrm\SaturdayLeaveController@saturdayLeaveUpdate');
    Route::get('/saturday-leave-details', 'App\Http\Controllers\hrm\SaturdayLeaveController@saturdayLeaveDetails');
    Route::post('/saturday-leave-details/get-test', 'App\Http\Controllers\hrm\SaturdayLeaveController@saturdayLeaveDetailsGet');
    Route::post('/saturday-leave-details/save-test', 'App\Http\Controllers\hrm\SaturdayLeaveController@saturdayLeaveDetailsSave');
});

//mail
Route::get('/attendance-performance','App\Http\Controllers\hrm\MailController@index');
Route::post('/sendMail', 'App\Http\Controllers\hrm\MailController@sendMail');
