<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\hrm\Emp_Mast_hd;
class TimeSheetEmail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data,$data_pp)
    {
        $this->data = $data;
        $this->data_pp = $data_pp;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $data= $this->data;
        $data_pp=$this->data_pp;
        $emp=Emp_Mast_hd::where('emp_number',$this->data['eng_cd'])->first();
        $dfr_date= date('d-M-Y', strtotime($this->data['report_dt']));
        $emp_name= $emp->emp_first_name .' '. $emp->emp_last_name;
        $subject= 'DFR Status ('.$emp['emp_number'].') ';
        return $this->from('automail@mawaimail.com','Mawai Infotech Limited')
        ->subject($subject)->view('hrm.emailTemplate.TimeSheetEmailTemp',compact('dfr_date','emp_name'));
    }
}
