<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\hrm\Emp_Mast_hd;
use App\Models\hrm\Email_configModal;
use App\Models\hrm\EmailErrorLogModal;
use DB;
class SendEmailExtraWorkingHours extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($post)
    {
        $this->post = $post;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $post=$this->post;
     
        $emp=Emp_Mast_hd::where('emp_number',$this->post['empmemb_emp_master_emp_number'])->first();
       // $client= DB::table('celint_master')->where('client_cd',$post['client_cd'])->first();
      //  $client= DB::table('celint_master_hw')->where('client_cd',$post['client_cd'])->first();

        $first = DB::table('celint_master')->select('client_cd','client_name')
        ->where('client_cd',$post['client_cd']);

        $client = DB::table('celint_master_hw')->select('client_cd','client_name')
               ->where('client_cd',$post['client_cd'])
                ->union($first)
                ->first();
               // dd($client->client_name);
        $emp_name= $emp->emp_first_name .' '. $emp->emp_last_name;
        $subject= 'Requesting for Extra Working Hours ('.$emp['emp_number'].') ';
        return $this->from('automail@mawaimail.com','Mawai Infotech Limited')
        ->subject($subject)->view('hrm.emailTemplate.ExtraWorkingHours',compact('post','emp_name','client'));
    }
}

