<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\hrm\Emp_Mast_hd;
use DB;
use App\Http\Controllers\Controller;
use App\Models\RequestForExtraWorkingHr;

class SendEmailEWHstatus extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($email_jobs)
    {
        $this->email_jobs = $email_jobs;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
       $email_jobs= $this->email_jobs;
        $emp_id=RequestForExtraWorkingHr::where('emp_extra_work_detail_id',$this->email_jobs['emp_extra_work_detail_id'])->first();
        $emp=Emp_Mast_hd::where('emp_number',$emp_id['empmemb_emp_master_emp_number'])->first();
        $emp_email_data=Emp_Mast_hd::where('emp_number',$emp['reporting_to'])->first();
        $emp_name= $emp->emp_first_name .' '. $emp->emp_last_name;
        $emp_name_reporting= $emp_email_data->emp_first_name .' '. $emp_email_data->emp_last_name;
        if($this->email_jobs['extra_granted']=='A'){
            $subject='Request for Extra working hours  Approved by ('.$emp_email_data['emp_number'].')';
        }elseif($this->email_jobs['extra_granted']=='R'){
            $subject='Request for Extra working Hours Rejected by ('.$emp_email_data['emp_number'].')';
        }elseif($this->email_jobs['extra_granted']=='C'){
            $subject='Request for Extra working Hours Cancelled by ('.$emp_email_data['emp_number'].')';
        }
        return $this->from('automail@mawaimail.com','Mawai Infotech Limited')
        ->subject($subject)->view('hrm.emailTemplate.ExtraWorkingHoursStatus',compact('email_jobs','emp','emp_email_data','emp_name','emp_name_reporting','emp_id'));
    }
}
