<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\hrm\Emp_Mast_hd;
use DB;

class SendEmailAttPerformance extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($emp_number)
    {
      
        $this->emp_number = $emp_number;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    
        // $prevmonth = date('M', strtotime("last month"));
    public function build(){
        $prevmonth = strtoupper(date('M', strtotime("last month")));
        $prevmonthYear = date('Y', strtotime("last month"));
       
        $emp_number=$this->emp_number;
        $emp=Emp_Mast_hd::select('emp_first_name','emp_last_name')->where('emp_number',$this->emp_number)->first();
        $data=DB::table('emp_att_perform_view')
        ->where('emp_no',$this->emp_number)
        ->where('month',$prevmonth)
        ->where('year',$prevmonthYear)
        ->orderBy('sl_no','ASC')
        ->get();
        
        //dd($data[0]->emp_no);
        $emp_name= $emp->emp_first_name .' '. $emp->emp_last_name;
        
        $subject= 'Attendance Performance of '.$emp_name.' ('.$emp_number.')  '.$prevmonth.'-'.$prevmonthYear;
    
        return $this->from('automail@mawaimail.com','Mawai Infotech Limited')
        ->subject($subject)->view('hrm.emailTemplate.AttedancePerformanceMail',compact('emp_name','emp_number','data','prevmonth','prevmonthYear'));
    }
}
