<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class MismatchEmail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    //protected $emaildata;
    public function __construct( $senddata,$files,$check_existence)
    {
   
        $this->senddata = $senddata;
        $this->files = $files;
        $this->check_existence = $check_existence;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $senddata= $this->senddata;
        $files= $this->files;
        $check_existence= $this->check_existence;
        $data=$this->senddata;
        $subject= 'Mismactch warning by  ('.$data['from_name'].')';

        if($files){
            if($check_existence){
             $this->from('automail@mawaimail.com','Mawai Infotech Limited')->subject($subject)
              ->view('hrm.emailTemplate.LocationWarningTemplate',compact('data'));
                foreach ($this->files as $file){
                    $this->attach($file);
                }
                return $this;

            }
            else{
                return $this->from('automail@mawaimail.com','Mawai Infotech Limited')->subject($subject)->view('hrm.emailTemplate.LocationWarningTemplate',compact('data'));
            }
            
        }
        else{
            return $this->from('automail@mawaimail.com','Mawai Infotech Limited')->subject($subject)
            ->view('hrm.emailTemplate.LocationWarningTemplate',compact('data'));
        }
        
    }
}
