<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\hrm\ImpClaimHead;
use App\Models\hrm\ImpClaimDetail;
use App\Models\hrm\EmpMaster;
use App\Models\hrm\OtherApprovalConfig;
use App\Models\hrm\Email_configModal;

class ImprestClaimMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($entry_no,$files)
    {
        $this->entry_no = $entry_no;
        $this->files = $files;
    }


    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $file = $this->files;
        $res=ImpClaimHead::where('entry_no',$this->entry_no)->first();
         $emp=EmpMaster::where('emp_number',$res->eng_cd)->first();
         $resDtl=ImpClaimDetail::where('entry_no',$this->entry_no)->get();
         $subject= 'Imprest Claim request by '.$emp->emp_first_name .' '.$emp->emp_last_name .'('.$emp->emp_number.') Entry No:'.$this->entry_no;

         if($file){
            $this->from('automail@mawaimail.com','Mawai Infotech Limited')->subject($subject)->view('hrm.emailTemplate.ImprestClaim',compact('resDtl'));
            foreach($this->files as $files){
                $this->attach($files);
            }
         }
         else{
            $this->from('automail@mawaimail.com','Mawai Infotech Limited')->subject($subject)->view('hrm.emailTemplate.ImprestClaim',compact('resDtl'));
         }
         return $this;
    }
}
