<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\hrm\ImpClaimHead;
use App\Models\hrm\ImpClaimDetail;
use App\Models\hrm\EmpMaster;
use App\Models\hrm\OtherApprovalConfig;
use App\Models\hrm\Email_configModal;

class ImprestClaimAppRejMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($entry_no,$status,$login_Approver)
    {
        $this->entry_no = $entry_no;
        $this->status = $status;
        $this->login_Approver = $login_Approver;
    }


    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    { 
        $res=ImpClaimHead::where('entry_no',$this->entry_no)->first();
         $emp=EmpMaster::where('emp_number',$res->eng_cd)->first();
         $emp_approver=EmpMaster::where('emp_number',$this->login_Approver)->first();
         $resDtl=ImpClaimDetail::where('entry_no',$this->entry_no)->get();
         $status=$this->status;
         if($status == 'A'){
            $subject= 'Imprest Claim Approved by '.$emp_approver->emp_first_name .' '.$emp_approver->emp_last_name .'('.$emp_approver->emp_number.') Entry No:'.$this->entry_no;
         }
         elseif($status == 'R'){
            $subject= 'Imprest Claim Rejected by '.$emp_approver->emp_first_name .' '.$emp_approver->emp_last_name .'('.$emp_approver->emp_number.') Entry No:'.$this->entry_no;
         }
         return $this->from('automail@mawaimail.com','Mawai Infotech Limited')
        ->subject($subject)->view('hrm.emailTemplate.ImprestClaimAppRej',compact('resDtl','status'));
    }
}
