<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class UploadImage implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $img;
    protected $data;
    protected $uniqid;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($img, $data, $uniqid)
    {
        $this->img = $img;
        $this->data = $data;
        $this->uniqid = $uniqid; 
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle(){
        $img = $this->img;
        $data = $this->data;
        $folderPath = public_path()."/attendance/";
        $image_parts = explode(";base64,", $img);
        $image_type_aux = explode("image/", $image_parts[0]);
        $image_type = $image_type_aux[1];
        $image_base64 = base64_decode($image_parts[1]);
        //$uniqid = uniqid();
        $uniqid = $this->uniqid;
        $filepath = $data->emp_cd . $uniqid . '.'.$image_type;
        $file = $folderPath . $data->emp_cd . $uniqid . '.'.$image_type;
        file_put_contents($file, $image_base64);
        return true;
    }
}
