<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use DB;

class UpdateAttendanceODB implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $ENG_CD;
    protected $FULLDATE;
    protected $PUNCH_TIME;
    protected $LONGITUDE;
    protected $LATITUDE;
    protected $ADDRESS;
    protected $PUNCH_TYPE;
    protected $P_TYPE;
    protected $ENTRY_DATE;
    protected $PUNCH_DATETIME;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($ENG_CD, $FULLDATE, $PUNCH_TIME, $LONGITUDE, $LATITUDE, $ADDRESS, $PUNCH_TYPE, $P_TYPE, $ENTRY_DATE, $PUNCH_DATETIME)
    {
        $this->ENG_CD = $ENG_CD;
        $this->FULLDATE = $FULLDATE;
        $this->PUNCH_TIME = $PUNCH_TIME;
        $this->LONGITUDE = $LONGITUDE;
        $this->LATITUDE = $LATITUDE;
        $this->ADDRESS = $ADDRESS;
        $this->PUNCH_TYPE = $PUNCH_TYPE;
        $this->P_TYPE = $P_TYPE;
        $this->ENTRY_DATE = $ENTRY_DATE;
        $this->PUNCH_DATETIME = $PUNCH_DATETIME;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle(){
        $ENG_CD = $this->ENG_CD;
        $FULLDATE = $this->FULLDATE;
        $PUNCH_TIME = $this->PUNCH_TIME;
        $LONGITUDE = $this->LONGITUDE;
        $LATITUDE = $this->LATITUDE;
        $ADDRESS = $this->ADDRESS;
        $PUNCH_TYPE = $this->PUNCH_TYPE;
        $P_TYPE = $this->P_TYPE;
        $ENTRY_DATE = $this->ENTRY_DATE;
        $PUNCH_DATETIME = $this->PUNCH_DATETIME;

        $attendance = DB::connection('oracle')->table('VEGA_ATT_APIDATA')->insert(["ENG_CD" => $ENG_CD, "FULLDATE" => $FULLDATE, "PUNCH_TIME" => $PUNCH_TIME, "LONGITUDE" => $LONGITUDE, "LATITUDE" => $LATITUDE, "ADDRESS" => $ADDRESS, "PUNCH_TYPE" => $PUNCH_TYPE, "P_TYPE" => $P_TYPE, "ENTRY_DATE" => $ENTRY_DATE, "PUNCH_DATETIME" => $PUNCH_DATETIME]);
        
        return true;
    }
}
