<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Mail\TimeSheetEmail;
use Mail;
use DB;
use App\Models\hrm\Emp_Mast_hd;

class TimeSheetEmailJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $data;
    protected $data_pp;

    public function __construct($data, $data_pp)
    {
        $this->data = $data;
        $this->data_pp = $data_pp;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $this->data ;
        $this->data_pp ;
       // dd($this->data['eng_cd']);
        $email = new TimeSheetEmail($this->data,$this->data_pp ); 
        $emp=Emp_Mast_hd::where('emp_number',$this->data['eng_cd'])->first();
        $emp_email = $emp['company_email'];
      // dd($this->emp_name->emp_number);
        Mail::to($emp_email)->send(new TimeSheetEmail($this->data,$this->data_pp));
    }
}
