<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Mail\NoPunchMail;
use Mail;
use App\Http\Controllers\Controller;

class SendEmailNoPunch implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $to_email;
    protected $emaildata;

    public function __construct($to_email,$emaildata)
    {
        $this->to_email = $to_email;
        $this->emaildata = $emaildata;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $email = new NoPunchMail($this->emaildata); 
        $to_email = $this->to_email;
       //dd($email->emaildata);
    $res= Mail::to($to_email)->send(new NoPunchMail($email));
   // dd($res);
    $cont=new Controller();
         $error_msg=true;
          $unit_cd=10001; 
          $emp_cd=$email->emaildata['emp_code'];
          $email_status='No-Punch';
          $cc='';
          $bcc='';
          $res1 = $cont->emailErrorLog($to_email,$cc,$bcc,$error_msg,$emp_cd,$email_status,$unit_cd);

    }
}
