<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Mail\SendEmailExtraWorkingHours;
use Mail;
use DB;
use App\Models\hrm\Emp_Mast_hd;
use App\Models\hrm\Email_configModal;
use App\Models\hrm\EmailErrorLogModal;
use App\Http\Controllers\Controller;
use App\Models\hrm\OtherApprovalConfig;
class SendEmailJobExtraWorkingHours implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $post;
    public function __construct($post)
    {
        $this->post = $post;

    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $this->post;
        $email = new SendEmailExtraWorkingHours($this->post); 
        $emp=Emp_Mast_hd::where('emp_number',$this->post['empmemb_emp_master_emp_number'])->first();
        
        $empRep=Emp_Mast_hd::where('emp_number',$emp['reporting_to'])->first();
        $count=OtherApprovalConfig::where('department_cd',$emp->area_mast_department_code)
        ->where('unit_cd',$emp->unit)
        ->where('active_status','ACTIVE')
        ->where('type_cd','EHW')
        ->count('auth_cd');
        if($count>0){
            $app_config=OtherApprovalConfig::where('department_cd',$emp->area_mast_department_code)
            ->where('unit_cd',$emp->unit)
            ->where('active_status','ACTIVE')
            ->where('type_cd','EHW')
            ->first();
            $empEmail=Emp_Mast_hd::where('emp_number',$app_config['auth_cd'])->first();
            $emp_email=$empEmail->company_email;
        }else{
            $emp_email = $empRep['company_email'];
        }
       
        $email_cc_config=Email_configModal::where('department_cd',$emp->area_mast_department_code)
        ->where('active_status','ACTIVE')->where('type_cd','applyextrahrs')->pluck('cc_to')->toArray();
        $emp_email_data=Emp_Mast_hd::where('emp_number',$this->post['empmemb_emp_master_emp_number'])->pluck('company_email')->toArray();
        $cc_data=array_filter(array_merge($email_cc_config,$emp_email_data));
        if(count($cc_data)>0){
            $cc=$cc_data;
        }else{
            $cc='noreply@mawaimail.com';
        }
        $email_bcc_config=Email_configModal::where('department_cd',$emp->area_mast_department_code)
        ->where('active_status','ACTIVE')->where('type_cd','applyextrahrs')->pluck('bcc_to')->toArray();
        $bcc_data=array_filter(array_merge($email_bcc_config));
        if(count($bcc_data)>0){
            $bcc=$bcc_data;
        }else{
            $bcc='noreply@mawaimail.com';
        }
      
       
        Mail::to($emp_email)->cc($cc)->bcc($bcc)->send(new SendEmailExtraWorkingHours($this->post));

          $cont=new Controller();
          $error_msg=true;
          $unit_cd=$emp['unit']; 
          $emp_cd=$this->post['empmemb_emp_master_emp_number'];
          $email_status='Request for Extra working Hours';
          $cc=$cc;
          $bcc=$bcc;
          $res1 = $cont->emailErrorLog($emp_email,$cc,$bcc,$error_msg,$emp_cd,$email_status,$unit_cd);
    }
}
