<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Mail;
use DB;
use App\Models\hrm\Emp_Mast_hd;
use App\Models\hrm\Email_configModal;
use App\Models\hrm\EmailErrorLogModal;
use App\Mail\SendEmailEWHstatus;
use App\Http\Controllers\Controller;
use App\Models\RequestForExtraWorkingHr;

class SendEmailJobEWHStatus implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $email_jobs;
    public function __construct($email_jobs)
    {
        $this->email_jobs = $email_jobs;

    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $this->email_jobs;
       // dd($this->email_jobs);
        $email = new SendEmailEWHstatus($this->email_jobs); 
        $emp_id=RequestForExtraWorkingHr::where('emp_extra_work_detail_id',$this->email_jobs['emp_extra_work_detail_id'])->first();
        $emp=Emp_Mast_hd::where('emp_number',$emp_id['empmemb_emp_master_emp_number'])->first();
        $emp_email = $emp['company_email'];
        $empRep=Emp_Mast_hd::where('emp_number',$emp['reporting_to'])->first();
       
        $email_cc_config=Email_configModal::where('department_cd',$emp->area_mast_department_code)
        ->where('active_status','ACTIVE')->where('type_cd','actionextrahrs')->pluck('cc_to')->toArray();
        $emp_email_data=Emp_Mast_hd::where('emp_number',$emp['reporting_to'])->pluck('company_email')->toArray();
        $cc_data=array_filter(array_merge($email_cc_config,$emp_email_data));
        if(count($cc_data)>0){
            $cc=$cc_data;
        }else{
            $cc='noreply@mawaimail.com';
        }
        $email_bcc_config=Email_configModal::where('department_cd',$emp->area_mast_department_code)
        ->where('active_status','ACTIVE')->where('type_cd','actionextrahrs')->pluck('bcc_to')->toArray();
        $bcc_data=array_filter(array_merge($email_bcc_config));
        if(count($bcc_data)>0){
            $bcc=$bcc_data;
        }else{
            $bcc='noreply@mawaimail.com';
        }

        Mail::to($emp_email)->cc($cc)->bcc($bcc)->send(new SendEmailEWHstatus($this->email_jobs));

        $cont=new Controller();
        $error_msg=true;
        $unit_cd=$emp['unit']; 
        $emp_cd=$emp_id['empmemb_emp_master_emp_number'];
        if($this->email_jobs['extra_granted']=='A'){
            $email_status='Request for Extra working hours  Approved';
        }elseif($this->email_jobs['extra_granted']=='R'){
            $email_status='Request for Extra working Hours Rejected';
        }elseif($this->email_jobs['extra_granted']=='C'){
            $email_status='Request for Extra working Hours Cancelled';
        }
        
        $cc=$cc;
        $bcc=$bcc;
        $res1 = $cont->emailErrorLog($emp_email,$cc,$bcc,$error_msg,$emp_cd,$email_status,$unit_cd);

    }
}
