<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use App\Models\hrm\Email_configModal;
use Illuminate\Queue\SerializesModels;
use DB;
use App\Mail\SendEmailAttPerformance;
use Mail;
use Session;
use App\Models\EmployeeMaster;
use App\Http\Controllers\Controller;
use App\Models\hrm\Emp_Mast_hd;
use App\Models\hrm\EmpAttPerformMailModel;
use App\Models\hrm\RoleWiseEmpLov;

class SendAttPerformanceJobManualy implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
 
    protected $emp_cd;
    protected $message;
    protected $month;
    protected $year;
    protected $unit_cd;

    public function __construct($emp_cd, $message, $month, $year, $unit_cd){

        $this->emp_cd = $emp_cd;
        $this->message = $message;
        $this->month = $month;
        $this->year = $year;
        $this->unit_cd = $unit_cd;
    }
    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {

        $emp_data_for_email=Emp_Mast_hd::where('emp_number',$this->emp_cd)->first();
        $templateName = 'hrm.Mail.sendMail';

        $emaildata['leave_type']=DB::table('emp_att_perform_view')->where('emp_no',$emp_data_for_email->emp_number)->where('month',strtoupper($this->month))->where('year',$this->year)->get();

        $emaildata['emp_name']=$emp_data_for_email->emp_first_name.''.@$emp_data_for_email->emp_last_name;
        $emaildata['emp_email']=$emp_data_for_email->company_email;
        $emaildata['emp_number']=$emp_data_for_email->emp_number;
        $emaildata['emp_no']=$emp_data_for_email->emp_number;
        $emaildata['app_date']=date('d-m-Y');
        $emaildata['emp_last_name']=$emp_data_for_email->emp_last_name;
        $emaildata['emp_first_name']=$emp_data_for_email->emp_first_name;
        $emaildata['messages']=$this->message;

        $to_email=$emp_data_for_email->company_email;
        
        $cc_email=Email_configModal::where('type_cd','monthlyperfom')->where('department_cd',$emp_data_for_email->area_mast_department_code)->get()->pluck('cc_to')->toArray();
        $cc=implode(',', $cc_email);

        $bcc_email=Email_configModal::where('type_cd','monthlyperfom')->where('department_cd',$emp_data_for_email->area_mast_department_code)->get()->pluck('bcc_to')->toArray();
        $bcc=implode(',', $bcc_email);

        $subject=' Attendance Performance of '.$emaildata['emp_first_name'].' '.''.$emaildata['emp_last_name'].' ('.$emaildata['emp_no'].')';

        $senddata =$emaildata;

        $to_name=$emaildata['emp_name'];

        $from_email=$emp_data_for_email->company_email;
        
        $res=sendEmailGlobal($templateName,$to_email,$subject,$senddata,$cc,$bcc,$to_name,$from_email);
        
        
        if($res ===true){
            $status=1;
            $send_mail='send';
        }else{
            $status=0;
            $send_mail='failed';
        }
        
        $check_presence = EmpAttPerformMailModel::where('month',$this->month)->where('year',$this->year)->where('emp_no',$emp_data_for_email->emp_number)->where('unit_cd',$this->unit_cd)->first();
    
        if(!empty($check_presence)){
            $att_per = EmpAttPerformMailModel::where(['month'=>$this->month])->where(['year'=>$this->year])->where(['emp_no'=>$emp_data_for_email->emp_number])->first();
            $att_per->re_send_status = $status;
            $att_per->re_send_mail_status =  $send_mail;
            $att_per->re_send_date =  date('Y-m-d H:i:s');
            $att_per->re_send_error_message = $res;
        }else{
            $att_per = new EmpAttPerformMailModel();            
            $att_per->emp_no = $emp_data_for_email->emp_number;
            $att_per->month = $this->month;
            $att_per->year = $this->year;
            $att_per->email_id = $to_email;
            $att_per->status =    $status;
            $att_per->error_message=$res;
            $att_per->mail_status =$send_mail;
            $att_per->send_date = date('Y-m-d H:i:s');
            $att_per->created_by =$to_name;
            $att_per->created_at= date('Y-m-d H:i:s');
        }
        
        $att_per->save();
    }
}
