<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Mail\PunchOutEmail;
use Mail;
use App\Http\Controllers\Controller;

class PunchOutEmailJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $emp_name;
    protected $emaildata;

    public function __construct($emp_name, $emaildata)
    {
        $this->emp_name = $emp_name;
        $this->emaildata = $emaildata;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $email = new PunchOutEmail($this->emaildata); 
        $emp_data = $this->emp_name;
        Mail::to($emp_data->company_email)->send(new PunchOutEmail($email));
    }
}
