<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Http;

class PunchInSMSJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $sms;
    public function __construct($sms)
    {
        $this->sms = $sms;
    }


    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $sms= $this->sms;
        //dd($sms);
         $emp_id = trim($sms['value']['emp_id']);
         $unit_cd = $sms['value']['unit_cd'];
         $currDate = date('d-M-Y');
         $name= $sms['to_name'];
         $phone_no=$sms['phone_no'];
         $punchintime=$sms['intime'];
         $location=$sms['result1'];
         $location1=$sms['location1'];
    $currDate = date('d-M-Y');

    $allow_late = DB::select("select hrm.get_late_coming_allow('$emp_id','$currDate','$unit_cd')");
    $allow_late = $allow_late[0]->get_late_coming_allow;
    $allow_late = (int) $allow_late;

    $no_off_punch_late = DB::table('emp_att_comm_sms_view')->where('emp_number',$emp_id)->whereNotNull('late_punch')->whereMonth('att_date', Carbon::now()->month)->count();
    
    $username = env("SMS_USERNAME");
    $password = env("SMS_PASSWORD");
    $user_sender = env("SMS_SENDER");
    $entityID = env("SMS_ENTITY_ID");

    $apiURL_old = "http://nimbusit.co.in/api/swsendSingle.asp?username=$username&password=$password&sender=$user_sender&sendto=$phone_no&entityID=$entityID&templateID=1707166270027032195
    &message=Dear $name, Your incoming punch time is $punchintime and your punching location is $location,$location1.
     This is $no_off_punch_late late coming out of $allow_late limit.
     After $allow_late late comming treated as half day/LWP. Thanks MAWAI";

     $apiURL = "http://nimbusit.co.in/api/swsendSingle.asp?username=$username&password=$password&sender=$user_sender&sendto=$phone_no&entityID=$entityID&templateID=1707167117061033135&message=Dear $name, Your incoming punch time is $punchintime and your punching location is $location, $location1. Total late coming in this month is $no_off_punch_late. All late coming will be treated as half day/LWP. Thanks HR Team Mawai Infotech.";

     
    $response = Http::get(trim($apiURL));
    $statusCode = $response->status();
    $responseBody = json_decode($response->getBody(), true);
    return $responseBody;

    }
}
