<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Mail;
use DB;
use App\Mail\PunchInEmail;
use App\Http\Controllers\Controller;

class PunchInEmailJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $emp_name;
    protected $emaildata;

    public function __construct($emp_name, $emaildata)
    {
        $this->emp_name = $emp_name;
        $this->emaildata = $emaildata;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
         $email = new PunchInEmail($this->emaildata); 
        $emp_data = $this->emp_name;
      // dd($this->emp_name->emp_number);
        Mail::to($emp_data->company_email)->send(new PunchInEmail($email));
    }
}
