<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Mail;
use DB;
use App\Mail\MismatchEmail;
use App\Http\Controllers\Controller;

class MismatchWarningEmailJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $emp_data_for_email;
    protected $templateName;
    protected $to_email;
    protected $subject;
    protected $senddata;
    protected $cc;
    protected $bcc;
    protected $to_name;
    protected $from_email;
    protected $files;
    protected $check_existence;
    protected $unit_cd;
    protected $emp_id;

    public function __construct($emp_data_for_email,$templateName,$to_email,$subject,$senddata,$cc,$bcc,$to_name,$from_email,$files,$check_existence,$unit_cd,$emp_id)
    {
        $this->emp_data_for_email = $emp_data_for_email;
        $this->templateName = $templateName;
        $this->to_email = $to_email;
        $this->subject = $subject;
        $this->senddata = $senddata;
        $this->cc = $cc;
        $this->bcc = $bcc;
        $this->to_name = $to_name;
        $this->from_email = $from_email;
        $this->files = $files;
        $this->check_existence = $check_existence;
        $this->unit_cd = $unit_cd;
        $this->emp_id = $emp_id;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $email = new MismatchEmail($this->senddata,$this->files,$this->check_existence); 
        $emp_data = $this->emp_data_for_email->company_email;

        Mail::to($emp_data)->send(new MismatchEmail($this->senddata,$this->files,$this->check_existence));
    }
}
