<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Models\LeaveDetails;
use DB;

class LeaveApiOracelStatusUpdate implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $leave_detail_id;
    protected $post_data;
    public function __construct($leave_detail_id,$post_data)
    {
        $this->leave_detail_id = $leave_detail_id;
        $this->post_data = $post_data;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        if($this->post_data['leave_granted']=='C'){
            $lv['CANCEL_FRDT']=date('Y-m-d H:i:s',strtotime($this->post_data['cancel_frdt']));
            $lv['CANCEL_TODT']=date('Y-m-d H:i:s',strtotime($this->post_data['cancel_todt']));
            $lv['CANCEL_DAYS']=$this->post_data['cancel_days'];
            $lv['LEAVE_CANCELED']='';
            $lv['LAST_UPDATED_BY']=$this->post_data['last_updated_by'];
            $lv['LAST_UPDATE_DATE']=date('Y-m-d H:i:s');
            $lv['LEAVE_GRANTED']='C';
            $lv['REMARKS']=$this->post_data['remarks'];

        }elseif($this->post_data['leave_granted']=='A'){

           $lv['APR_BY']= $this->post_data['apr_by'];
           $lv['CHK_APR_BY']= $this->post_data['chk_apr_by'];
           $lv['LAST_UPDATED_BY']=  $this->post_data['last_updated_by'];
           $lv['LAST_UPDATE_DATE']=  date('Y-m-d H:i:s');
           $lv['LEAVE_GRANTED']=  $this->post_data['leave_granted'];
           $lv['APR_REMARKS']=  $this->post_data['apr_remarks'];

        }elseif($this->post_data['leave_granted']=='R'){
            $lv['APR_BY']= $this->post_data['apr_by'];
            $lv['CANCEL_FRDT']=date('Y-m-d H:i:s',strtotime($this->post_data['cancel_frdt']));
            $lv['CANCEL_TODT']=date('Y-m-d H:i:s',strtotime($this->post_data['cancel_todt']));
            $lv['CANCEL_DAYS']=$this->post_data['cancel_days'];
            $lv['LAST_UPDATED_BY']=$this->post_data['last_updated_by'];
            $lv['LAST_UPDATE_DATE']=date('Y-m-d H:i:s');
            $lv['LEAVE_GRANTED']=$this->post_data['leave_granted'];
            $lv['REMARKS']=$this->post_data['remarks'];

        }elseif($this->post_data['leave_granted']=='F'){
            $lv['FORWARD_TO']= $this->post_data['forward_to'];
            $lv['LAST_UPDATED_BY']=$this->post_data['last_updated_by'];
            $lv['LAST_UPDATE_DATE']=date('Y-m-d H:i:s');
        }
        $attendance = DB::connection('oracle')->table('LEAVE_DETAIL_APIDATA')->where('LEAVE_DETAIL_ID',$this->leave_detail_id)->update($lv);
        return true;
    }
}
