<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Models\LeaveDetails;
use DB;

class LeaveApiOracelInsert implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $lastInsertId;
    public function __construct($lastInsertId)
    {
        $this->lastInsertId = $lastInsertId;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
       $data= LeaveDetails::where('leave_detail_id',$this->lastInsertId)->first();

                 $lv['LEAVE_DESC_LEAVE_DESC_TYPE']=$data->leave_desc_leave_desc_type; 
                  $lv['EMPMEMB_EMP_MASTER_EMP_NUMBER']=$data->empmemb_emp_master_emp_number;
                  if($data->from_date !=''){
                    $lv['FROM_DATE']=date('Y-m-d H:i:s',strtotime($data->from_date));
                  }
                  if($data->end_date !=''){
                    $lv['END_DATE']=date('Y-m-d H:i:s',strtotime($data->end_date));
                  }
                 
                
                  $lv['LEAVE_GRANTED']=$data->leave_granted; 
                  $lv['SANCTIONED_BY']=$data->sanctioned_by;
                  $lv['LEAVE_DAYS']=$data->leave_days; 
                  $lv['REASON']=$data->reason; 
                  $lv['FIN_YEAR']=$data->fin_year;  
                  $lv['UNIT_CD']=$data->unit_cd;
                  $lv['GM']=$data->gm; 
                  $lv['DEPT_HEAD']=$data->dept_head;  
                  $lv['CHECK_BY']=$data->check_by;  
                  if($data->start_date !=''){
                    $lv['START_DATE']=date('Y-m-d H:i:s',strtotime($data->start_date));
                  }
                 
                  $lv['HOLD_LV1']=$data->hold_lv1;  
                  $lv['HOLD_LV2']=$data->hold_lv2; 
                  if($data->check_dt !=''){
                    $lv['CHECK_DT']= date('Y-m-d H:i:s',strtotime($data->check_dt));
                  }
                  if($data->dept_dt !=''){
                    $lv['DEPT_DT']= date('Y-m-d H:i:s',strtotime($data->dept_dt));
                  }
                
                  // if($data->cancel_frdt !=''){
                  //   $lv['CANCEL_FRDT']= date('Y-m-d H:i:s',strtotime($data->cancel_frdt));
                  // }
                  // if($data->cancel_todt !=''){
                  //   $lv['CANCEL_TODT']=date('Y-m-d H:i:s',strtotime($data->cancel_todt)); 
                  // }

                   
                  

                  $lv['CANCEL_DAYS']=$data->cancel_days;
                  $lv['LEAVE_CANCELED']=$data->leave_canceled; 
                  $lv['CANCEL_DEPT_HEAD']=$data->cancel_dept_head;  
                  if($data->cancel_dept_dt !=''){
                    $lv['CANCEL_DEPT_DT']=date('Y-m-d H:i:s',strtotime($data->cancel_dept_dt));
                  }
                 
                  $lv['APP_NO']=$data->app_no; 
                  if($data->app_date !=''){
                    $lv['APP_DATE']= date('Y-m-d H:i:s',strtotime($data->app_date));
                  }
                 
                  $lv['FULL_HALF_DAY']=$data->full_half_day;  
                  $lv['APR_REMARKS']=$data->apr_remarks;  
                  $lv['VER_REMARKS']=$data->ver_remarks;  
                  $lv['CHK_REMARKS']=$data->chk_remarks; 
                  $lv['CHK_APR_BY']=$data->chk_apr_by;  
                  $lv['CHK_VER_BY']=$data->chk_ver_by; 
                  $lv['CHK_CHK_BY']=$data->chk_chk_by; 
                  $lv['APR_BY']=$data->apr_by; 
                  $lv['VER_BY']=$data->ver_by; 
                  $lv['CHK_BY']=$data->chk_by; 
                  if($data->leave_type_det !=''){
                    $lv['LEAVE_TYPE_DET']= $data->leave_type_det;
                  }
                 
                  $lv['CREATED_BY']=$data->created_by;  
                  if($data->creation_date !=''){
                    $lv['CREATION_DATE']= date('Y-m-d H:i:s',strtotime($data->creation_date));  
                  }
                
                  $lv['LAST_UPDATED_BY']=$data->last_updated_by;  
                  if($data->last_update_date !=''){
                    $lv['LAST_UPDATE_DATE']=  date('Y-m-d H:i:s',strtotime($data->last_update_date));
                  }
                  
                  $lv['OBJECT_VERSION_NUMBER']=$data->object_version_number;  
                 
                  $lv['LEAVE_TYPE_DET2']=$data->leave_type_det2;  
                  $lv['CREATED_AT']=date('Y-m-d H:i:s');  
                  $lv['UPDATED_AT']=date('Y-m-d H:i:s');
                  $lv['LEAVE_DETAIL_ID']=$data->leave_detail_id;  
                  $lv['CC_TO']=$data->cc_to; 
                  $lv['FORWARD_TO']=$data->forward_to; 
                  $lv['REMARKS']=$data->remarks; 
                  $lv['MAIL_STATUS']=$data->mail_status;  
                  $lv['SMS_STATUS']=$data->sms_status;  
                  $lv['WHATSAPP_STATUS']=$data->whatsapp_status;
       $attendance = DB::connection('oracle')->table('LEAVE_DETAIL_APIDATA')->insert($lv);
        
       return true;
    }
}
