<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Models\hrm\ImpClaimHead;
use App\Models\hrm\ImpClaimDetail;
use App\Models\hrm\EmpMaster;
use App\Models\hrm\OtherApprovalConfig;
use App\Models\hrm\Email_configModal;
use App\Http\Controllers\Controller;
use DB;
use App\Mail\ImprestClaimAppRejMail;
use Mail;

class ImprestClaimAppRej implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $entry_no;
    protected $status;
    protected $login_Approver;
    public function __construct($entry_no,$status,$login_Approver)
    {
        $this->entry_no = $entry_no;
        $this->status = $status;
        $this->login_Approver = $login_Approver;
    }


    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
         $res=ImpClaimHead::where('entry_no',$this->entry_no)->first();
         $emp=EmpMaster::where('emp_number',$res->eng_cd)->first();
         $login_emp=EmpMaster::where('emp_number',$this->login_Approver)->first();
         $otherappr=OtherApprovalConfig::where('type_cd','IC')
         ->where('active_status','ACTIVE')
         ->where('department_cd',$emp->area_mast_department_code)
         ->where('unit_cd',$emp->unit)
         ->first();
         $empapproval=EmpMaster::where('emp_number',$otherappr->auth_cd)->first();
         $resDtl=ImpClaimDetail::where('entry_no',$this->entry_no)->get();
         //$empapproval->company_email;
        //  $login_emp->company_email;
         $email_cc_config=Email_configModal::where('department_cd',$emp->area_mast_department_code)
         ->where('active_status','ACTIVE')->where('type_cd','icapply')->pluck('cc_to')->toArray();
         $emp_email_data=EmpMaster::where('emp_number',$emp['reporting_to'])->pluck('company_email')->toArray();
         $cc_data=array_filter(array_merge($email_cc_config,$emp_email_data));
         if(count($cc_data)>0){
             $cc=$cc_data;
         }else{
             $cc='noreply@mawaimail.com';
         }


         $email_bcc_config=Email_configModal::where('department_cd',$emp->area_mast_department_code)
         ->where('active_status','ACTIVE')->where('type_cd','icapply')->pluck('bcc_to')->toArray();
         $bcc_data=array_filter(array_merge($email_bcc_config));
         if(count($bcc_data)>0){
             $bcc=$bcc_data;
         }else{
             $bcc='noreply@mawaimail.com';
         }

         $res= Mail::to($login_emp->company_email)->cc($cc)->bcc($bcc)->send(new ImprestClaimAppRejMail($this->entry_no,$this->status,$this->login_Approver));

        $cont=new Controller();
        $error_msg=true;
        $unit_cd=$emp['unit']; 
        $emp_cd=$emp->emp_number;
        $email_status='Request for Imprest Claim';
        $cc=$cc;
        $bcc=$bcc;

        $res1 = $cont->emailErrorLog($empapproval->company_email,$cc,$bcc,$error_msg,$emp_cd,$email_status,$unit_cd);
    }
}
