<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use DB;
use App\Models\hrm\TimeSheetHd;
use App\Models\hrm\TimeSheetDetail;
use App\Models\hrm\TimeSheetHdTemp;
use App\Models\hrm\TImeSheetDetailTemp;

class FinalSubmitDfr implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $lastInsertId;
    public function __construct($lastInsertId)
    {
        $this->lastInsertId = $lastInsertId;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $tempHd_data=TimeSheetHdTemp::where('term_log_clt_hd_temp_id',$this->lastInsertId)->first();
        $data['entry_no']=$tempHd_data['entry_no'];
        $data['entry_dt']=date('Y-m-d H:i:s',strtotime($tempHd_data->entry_dt));
        $data['report_dt']= date('Y-m-d H:i:s',strtotime($tempHd_data->report_dt));
        $data['eng_cd']=$tempHd_data->eng_cd;
        $data['in_time']=date('Y-m-d H:i:s',strtotime($tempHd_data->in_time));
        $data['out_time']=date('Y-m-d H:i:s',strtotime($tempHd_data->out_time));
        $data['total_working_hour']=$tempHd_data->working_hours;
        $data['app_by']=$tempHd_data->app_by;
        $data['app_on_date']=date('Y-m-d H:i:s');
        $data['sent_status']='Y';
        $data['user_location']=$tempHd_data->user_location;
        $data['remarks']='';
        $data['unit_cd']=$tempHd_data->unit_cd;
        $data['created_by']=$tempHd_data->created_by;
        $data['created_at']=date('Y-m-d H:i:s');
        $data['object_version_number']=1;
        $res=TimeSheetHd::insert($data);
        $lastInsertId   = DB::getPdo()->lastInsertId();
        //details data insert

    $dtlData=TImeSheetDetailTemp::where('term_log_clt_temp_id',$this->lastInsertId)->get();
    if(count($dtlData)>0){
            foreach($dtlData as $row){
                $data_pp['entry_no']  = $row->entry_no;
                $data_pp['entry_dt']        = date('Y-m-d H:i:s',strtotime($row->entry_dt));
                $data_pp['erp_ver']         = $row->erp_ver;
                $data_pp['submodule']       = $row->submodule;
                $data_pp['project']         =$row->project;
                $data_pp['module']           = $row->module;
                $data_pp['problem']          = $row->problem;
                $data_pp['action']           = $row->action;
                $data_pp['timetaken']        = $row->timetaken;
                $data_pp['fileupload_path'] = $row->fileupload_path;
                $data_pp['unit_cd']          = $row->unit_cd;
                $data_pp['created_by']       = $row->created_by;
                $data_pp['status']           = $row->status;
                $data_pp['term_log_clt_id']   = $lastInsertId;
                $data_pp['created_at']   = date('Y-m-d H:i:s');
                $data_pp['object_version_number']   = 1;
                TimeSheetDetail::insert($data_pp);

            }
      }
      $deleteDtl=  TImeSheetDetailTemp::where('term_log_clt_temp_id',$this->lastInsertId)->delete();
    $delete=  TimeSheetHdTemp::where('term_log_clt_hd_temp_id',$this->lastInsertId)->delete();

   
    }
}
