<?php

namespace App\Http\Controllers; 
use App\Http\Controllers\Controller;
use DB;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Storage;
use Session;
use Validator;
use App\Models\hrm\Emp_Mast_hd;
use App\Models\UserMaster;
use App\Models\Company;
use App\Models\Suggesion;
use App\Models\hrm\ShiftMaster;
use Cookie;
use Illuminate\Http\Response;
use App\Models\hrm\Attendance;
use Config;
use App\Models\LeaveDetails;
use App\Models\FavoriteMenu;
use App\Models\hrm\FileMaster;
use App\Models\hrm\Email_configModal;
use Illuminate\Support\Facades\Hash; 
use App\Models\hrm\MonthWiseAttendanceView;

class TermsController {

    /** 
     * Display a login page.
     *
     * @return \Illuminate\Http\Response
     */    
    public function login(){
        return view('login');  
    }

    /**
	 * This function use for admin login action
	 *
	 * @return admin login page
	 */
	public function loginAction(Request $request){		
//dd($request->all());
		$validator = Validator::make($request->all(), [
			'emp_cd' => 'required',
			'password' => 'required',
		]);

		if($validator->fails()) { 
			$error_msg = $validator->errors()->all();
			return back()->with('flash_error',$error_msg[0])->withInput();          
        }  

		try{
	
			if (!$token = auth()->attempt($validator->validated())) {
				return back()->withInput()->with('flash_error','Invailid User, Please try again!');
			}
			
			$company = Company::first();
			$user = auth()->user();
			
			if($user != ""){
				$role_id = DB::select("select user_role_id from user_role where role_code ='".$user->role_centre."'")[0]->user_role_id;
				$department_code=Emp_Mast_hd::where('emp_number',$user->emp_cd)->where('unit',$user->unit_cd)->first();
				//  dd($department_code);
				$request->session()->put('user_id', $user->user_master_id);
				$request->session()->put('user_name', $user->user_name);
				$request->session()->put('emp_id', $user->emp_cd);
				$request->session()->put('unit_cd', $user->unit_cd);
				$request->session()->put('role_centre', $user->role_centre);
				$request->session()->put('role_id', $role_id);
				$request->session()->put('unit_name', 'Mawai Infotech Limited');
				$request->session()->put('fin_year', '22-23');
				$request->session()->put('search', '');
				$request->session()->put('comp_cd', $company->code);
				$request->session()->put('dept_cd', $department_code->area_mast_department_code);
				$request->session()->put('photo_file', $department_code->photo_file);
				return redirect('/checkin');
			}else{
				return back()->with('flash_error','Invailid User, Please try again!')->withInput();
			}
		}catch(Exseption $e){
			return response()->withInput()->json(['error' => $e->getMessage()]);
		}
	}

	
    /**
	 * This function use for logout admin 
	 *
	 * @return admin login page
	 */
	public function logout(Request $request){
		session()->flush();
		return redirect('/');
	}

    /** 
     * Display a dashboard page.
     *
     * @return \Illuminate\Http\Response
     */
    public function dashboard(){
		$emp_cd = session()->get('emp_id');
		$unit_cd = session()->get('unit_cd');
		$emp_births = DB::table('emp_birth_db_view')->get();
		$emp_workanniversaries = DB::table('emp_workanniversary_db_view')->take(5)->get();
		$emp_newjoins = DB::table('emp_newjoin_db_view')->take(5)->get();
		$emp_holidays = DB::table('emp_holiday_db_view')->get();
		$emp_leave= DB::table('leave_detail')->join('leave_mast', 'leave_detail.leave_desc_leave_desc_type', '=', 'leave_mast.code')->select('leave_detail.*','leave_mast.code','leave_mast.description')->where('leave_detail.empmemb_emp_master_emp_number',$emp_cd)->whereBetween('leave_detail.from_date',[date('Y-m-d 00:00:00'),date('Y').'-12-31'])->get();
		$emp_leavess= DB::table('leave_detail')->join('leave_mast', 'leave_detail.leave_desc_leave_desc_type', '=', 'leave_mast.code')->select('leave_detail.*','leave_mast.code','leave_mast.description')->where('leave_detail.empmemb_emp_master_emp_number',$emp_cd)->whereBetween('leave_detail.from_date',[date('Y-m-d 00:00:00'),date('Y').'-12-31'])->get();

		//notic-board
		$current_date=date("Y-m-d");
		$department_code=DB::table('emp_master_hd')->where('emp_number',$emp_cd)->first()->area_mast_department_code;

		$notice_board = DB::table('event_announcement_dtl')->whereDate('event_start_date','<=',$current_date)->whereDate('event_end_date','>=',$current_date)->where('share_to_board','Y')->where(function($q) use ($department_code){
			$q->where('department','=',$department_code);
			$q->orWhere('department','=','%');
		})->where('share_to_board','Y')->get();
		$suggesion = Suggesion::where('unit_cd',$unit_cd)->get();
		$favorite_menu = FavoriteMenu::where('unit_cd',$unit_cd)->where('emp_cd',$emp_cd)->get();
		foreach($favorite_menu as $fav_menu){
			$file = FileMaster::where('file_id',$fav_menu->file_id)->first();
			$fav_menu->file_name = $file->file_name;
			$fav_menu->flow_path = $file->flow_path;
		}
		// dd($favorite_menu);



		$last_30_day_dt = date('Y-m-d', strtotime('-30 days'));
        $current_date= date('Y-m-d');
		$onTimePunchData=array();
		$onTimePunch=Attendance::where('unit_cd',$unit_cd)
		->where('empcode',$emp_cd)
		->where('p_type','I')
		->whereDate('officepunch','>=',$last_30_day_dt)
		->whereDate('officepunch','<=',$current_date)
		->whereTime('officepunch','<=','10:00:00')
		->get();


		



		// foreach($onTimePunch as $row){
		// 	$data_row['checkin_time']=$row->officepunch;
		// 	$data_row['checkin_out']=Attendance::where('unit_cd',$unit_cd)->where('empcode',$emp_cd)->where('p_type','O')->whereDate('officepunch',$row->officepunch)->max('officepunch');
		// 	$onTimePunchData[]=$data_row;
		// }


		//Late Checkin Data Start Here
		$latePunchData=array();
		$latePunch=Attendance::where('unit_cd',$unit_cd)
		->where('empcode',$emp_cd)
		->where('p_type','I')
		->whereDate('officepunch','>=',$last_30_day_dt)
		->whereDate('officepunch','<=',$current_date)
		->whereTime('officepunch','>=','10:00:00')
		->get();


		// foreach($latePunch as $rowdt){
		// 	$data_row['checkin_time']=$rowdt->officepunch;
		// 	$data_row['checkin_out']=Attendance::where('unit_cd',$unit_cd)->where('empcode',$emp_cd)->where('p_type','O')->whereDate('officepunch',$rowdt->officepunch)->max('officepunch');
		// 	$latePunchData[]=$data_row;
		// }




		$miss_punch_list = DB::select("SELECT *  FROM hrm.emp_mispunch_view WHERE NOT EXISTS (SELECT * 
     	FROM hrm.mis_punch_hd 
     	WHERE emp_mispunch_view.emp_number = mis_punch_hd.empmemb_emp_master_emp_number 
     	and date(emp_mispunch_view.att_date)=date(mis_punch_hd.mis_punch_date)) and
     	emp_mispunch_view.emp_number='$emp_cd' and
     	emp_mispunch_view.unit_cd ='$unit_cd' order by emp_mispunch_view.att_date desc");

		// shift_time  
		$emp_data=Emp_Mast_hd::select('shift','card_no','emp_number')->where('emp_number',$emp_cd)->where('unit',$unit_cd)->first();
		if($emp_data){
			$shift_time=ShiftMaster::where('unit_cd',$unit_cd)->where('shift_code',$emp_data->shift)->first();
		}else{
			$shift_time=ShiftMaster::where('id_header',1)->first();
		}
		$month=date('M');
		$ontime_count=MonthWiseAttendanceView::where('emp_number',$emp_cd)
		->where('unit_cd',$unit_cd)
		->where('yr',date('Y'))
		->where('mon',strtoupper($month))
		// ->whereDate('att_date','>=',$last_30_day_dt)
		// ->whereDate('att_date','<=',$current_date)
		->whereTime('in_time','<=','10:00:00')
		->whereNotNull('in_time')
		->whereNotNull('out_time')
		->count('emp_number');

		$late_count=MonthWiseAttendanceView::where('emp_number',$emp_cd)
		->where('unit_cd',$unit_cd)
		->where('yr',date('Y'))
		->where('mon',strtoupper($month))
		// ->whereDate('att_date','>=',$last_30_day_dt)
		// ->whereDate('att_date','<=',$current_date)
		->whereTime('in_time','>=','10:00:00')
		->whereNotNull('in_time')
		->whereNotNull('out_time')
		->count('emp_number');

		
		$onTimePunchData=MonthWiseAttendanceView::where('emp_number',$emp_cd)
		->where('unit_cd',$unit_cd)
		->where('yr',date('Y'))
		->where('mon',strtoupper($month))
		// ->whereDate('att_date','>=',$last_30_day_dt)
		// ->whereDate('att_date','<=',$current_date)
		->whereTime('in_time','<=','10:00:00')
		->whereNotNull('in_time')
		->whereNotNull('out_time')
		->get();

		$latePunchData=MonthWiseAttendanceView::where('emp_number',$emp_cd)
		->where('unit_cd',$unit_cd)
		->where('yr',date('Y'))
		->where('mon',strtoupper($month))
		// ->whereDate('att_date','>=',$last_30_day_dt)
		// ->whereDate('att_date','<=',$current_date)
		->whereTime('in_time','>=','10:00:00')
		->whereNotNull('in_time')
		->whereNotNull('out_time')
		->get();
			
			


		return view('dashboard', compact('emp_births','emp_workanniversaries','emp_newjoins','emp_holidays','suggesion','onTimePunchData','latePunchData','miss_punch_list','shift_time','emp_data','emp_leave','emp_leavess','favorite_menu','notice_board','current_date','late_count','ontime_count'));  

		

    }

	/** 
     * Display a suggesion box.
     *
     * @return \Illuminate\Http\Response
     */
	public function Suggesion(Request $request){
		$value = $request->session()->all();
		$empcd = $value['emp_id'];
		$unit_cd = $value['unit_cd'];
		$user_id = $value['user_id'];
		$user_name = $value['user_name'];
		try{
			// dd($request->all());
			$emp_mst_hd = Emp_Mast_hd::where('emp_number',$empcd)->first();
			if(isset($request->suggesion)){
				$sugg = new Suggesion();
				$sugg->emp_code = $empcd;
				$sugg->sugg_date = date('Y-m-d');
				$sugg->sugg_detail = $request->suggesion;
				$sugg->desig_code = @$emp_mst_hd->desig_code;
				$sugg->dept_code  = @$emp_mst_hd->area_mast_department_code;
				$sugg->unit_cd = $unit_cd;
				$sugg->created_by = $empcd;
				$sugg->created_at = date('Y-m-d');
				$sugg->object_version_number = 1;
				$save = $sugg->save();
				if($save)
				{
					return response()->json(['status'=> 1 , 'message'=>'Suggesion Saved']);
				}
				else {
					return response()->json(['status'=> 0 , 'message'=>'Suggesion not Saved']);
				}
			}
			else{
				return response()->json(['status'=> 0 , 'message'=>'Suggesion is blank']);
			}

			
			
		}catch(Exseption $e){
			return response()->json(['error' => $e->getMessage()]);
		}
	}

	/** 
     * Display a dashboard page all birthday emps.
     *
     * @return \Illuminate\Http\Response
     */
    public function allBirthdayEmp(){
		$emp_births = DB::table('emp_birth_db_view')->get();
		return view('birthdayall', compact('emp_births'));  
    }

	/** 
     * Display a dashboard page all emp Work Anniversary.
     *
     * @return \Illuminate\Http\Response
     */
    public function allWorkAnniversaryEmp(){
		$emp_workanniversaries = DB::table('emp_workanniversary_db_view')->get();
		return view('workanniversaryall', compact('emp_workanniversaries'));  
    }

	/** 
     * Display a dashboard page all new employee joinees.
     *
     * @return \Illuminate\Http\Response
     */
    public function allNewEmp(){
		$newjoinees = DB::table('emp_newjoin_db_view')->get();
		return view('newjoinees', compact('newjoinees'));  
    }
	
	public function showappscreen($id){
		$token = $_GET['_ts'];
		$user = session()->get($token);
		$empcd = $user['emp_id'];
		$appdata = DB::table('doc_app_view')->where('doc_app_type',$id)->where('emp_cd', '=', $empcd)->get();
		session()->put($token.'.approvalscreen', $id);
        return view ("approvalscreen",compact('appdata'));
    }

	// This function use for manage the login sassion
	public function getAllUserLogins(){
		$token = $_GET['_ts'];
		$user = session()->get($token);
		//dd($user);
		$empcd = $user['emp_id'];
		$units = Unit::select('code')->distinct()->get();
		$login_users = LoginPermission::where('current_status', '1')->with('getUser')->get();
		$login_ips = LoginPermission::where('current_status', '1')->distinct('ip')->get();

        return view ("SEC.loginusers",compact('login_users','units','login_ips','user'));
    }

	// This function use for manage the login sassion
	public function killLoginByToken($id){
		$login_users = LoginPermission::where('token', $id)->first();
		$login_users->current_status = 0;
		$login_users->save();
        $token = @$_REQUEST['_ts'];
        return redirect('/manageloginuser?_ts='.$token)->with('flash_success','Login Sassion Kill Successfull!');
    }

	// This function use for logout all login users
	public function killAllLoginUsers(){
		$login_users = LoginPermission::where('current_status', '1')->update(['current_status' => 0]);
        return 'All Login Sassion Kill Successfull!';
    }


    public function usersActivityDetails(Request $req){
    	$ts = $req->ts;
    	//dd($ts);
    	$users_activi_dtl = UserSessionDetl::where('http_session',$ts)->get();

    	$count = $users_activi_dtl->count();
            if($count == 0){
				return response()->json(['status' => 0, 'msg' => 'Data Not Found!']);
			}else{
                $record = '';
                $record .= '<table class="table table-bordered  table-hover">
                <thead>
                <tr class="hDiv">
               
                    <td>ID</td>
                    <td>IP</td>
                    <td>Module</td>
                    <td>Open Time</td>
                    <td>Session No</td>
                </tr>
                </thead>
                <tbody>';
                foreach($users_activi_dtl as $row){
                	//$unit_name =  getUnitName($row['unit_code']);
                    $record .= '<tr>
                	<td>'.$row['user_id'].'</td>                   
                    <td >'.$row['machine'].'</td>
                    <td>'.$row['doc_name'].'</td>
                    <td>'.date('d/m/Y H:i:s',strtotime($row['created_at'])).'</td>
                    <td>'.$row['http_session'].'</td>
                    </tr>';
                }
                $record .= '</tbody>
                </table>';
            }

		return response()->json(['status' => 1, 'msg' => 'This is matched data!','data' => $record]);
    }

    public function changePassword(Request $request){
    	// 
    	return view('hrm.ChangePassword.Password');

    }

    public function saveChangePassword(Request $request){
    	DB::beginTransaction();
    	$value = $request->session()->all();
    	$emp_data=UserMaster::where('emp_cd',$value['emp_id'])->where('unit_cd',$value['unit_cd'])->first();
    	if(Hash::check($request->password, $emp_data->password)){
	        try{
	    		$post=[
	    			'password' => Hash::make($request->new_password),
	            	'confirm_pwd' => Hash::make($request->confirm_password),
	    		];
	    		$save  = UserMaster::where('unit_cd',$value['unit_cd'])->where('emp_cd',$value['emp_id'])->update($post);
		    		DB::commit();
		            if($save){
		                return response()->json(['status' => 1, 'message' => 'Your Password Sucessfully Changed.']);
		            } 
	        }catch(Exception $e){
	            DB::rollback();
	            return response()->json(['status' => 0, 'message' => $e->getMessage()]);
	        }
    	}else{
	        DB::rollback();
    		return response()->json(['status' => 0, 'message' => "Your password doesn't match"]);
    	}
    }

	







	/**
	 * This function use for get the admin dashboard details 
	 *
	 * @return admin login page
	 */
	public function selectmodule(){
		$token = $_GET['_ts'];
		if (session()->exists($token)) {
			$log_user = session()->get($token);
			$modules = UserPriv::select('file_id')->where('user_id', $log_user['id'])->where(function($q) {
				$q->orWhere('p_add', 'Y')
				  ->orWhere('p_modify', 'Y')
				  ->orWhere('p_view', 'Y')
				  ->orWhere('p_del', 'Y');
			})->get();
			
			$file_master = array();
			foreach($modules as $module){
				$file_master[] = $module->file_id;
			}
			
			$access_modules = erpmenumodel::select('modl')
				->where('show_flag', '=', 'Y') 
				->whereIn('file_id', $file_master)
				->with('moduleDetails')
				->distinct('modl')
				->get();
			return view('selectmodule',compact('access_modules'));
		}else{
			return redirect('/');
		}
	}

	/**
	 * This function use for set active module
	 *
	 * @return page
	 */
	public function setActiveModule($module,$form = null){	

		try{
			$token = $_GET['_ts'];
			//dd($token);
			$user = session()->get($token);

			
			
			if($form != null){
				$path = '/'.$form;
				$filename = FileMaster::select('file_sname','modl')->where('flow_path',$path)->first();
                if(isset($filename)){
                	$module = $filename->modl;
                    
				}
			}
			if ($token != '') {
				
				session()->forget($token.'.activemodule');
				session()->put($token.'.activemodule', $module);

				if($module == 'SALE'){
					if($form != null){
						return response(['url' => '/sale/sale-dashboard?_ts='.$token]);
					}else{
						return redirect('/sale/sale-dashboard?_ts='.$token);
					}

					
				}else{
					return redirect('/dashboard?_ts='.$token);
				}
				
			}else{
				return redirect('/');
			}
		}catch(Exseption $e){
			return response()->json(['error' => $e->getMessage()]);
		}
	}


	/**
	 * This function use for side menu open close manage sassion
	 *
	 * @para $cstatus String
	 * @return page
	 */
	public function setSideManuOCStatus(Request $request){		
		try{
			$token = $request->_ts;
			$cstatus = $request->current;
			$user = session()->get($token);
			if ($token != '') {
				if($cstatus == 'open'){
					$status = 'close';
				}else{
					$status = 'open';
				}
				session()->forget($token.'.smanu');
				session()->put($token.'.smanu', $status);
				return response()->json(['error' => 0, 'menu_now' => $status]);
			}else{
				return response()->json(['error' => 1]);
			}
		}catch(Exseption $e){
			return response()->json(['error' => $e->getMessage()]);
		}
	}

	/** 
     * Display a accessDenied page.
     *
     * @return \Illuminate\Http\Response
     */
    public function accessDenied(){
		try{
			$token = $_GET['_ts'];
			if (session()->exists($token)) {
				$log_user = session()->get($token);
				$user_name = $log_user['name'];
				return view('accessdenied', compact('user_name')); 
			}else{
				return redirect('/');
			}
		}catch(Exseption $e){
			return response()->json(['error' => $e->getMessage()]);
		} 
    }

	/** 
     * Cross the no user login user permission.
     *
     * @return \Illuminate\Http\Response
     */
    public function crossNoOfLoginUser(){
		try{
			return view('crosslimit'); 
		}catch(Exseption $e){
			return response()->json(['error' => $e->getMessage()]);
		} 
    }

	/** 
     * Get the assigned unit by user.
     *
     * @return \Illuminate\Http\Response
     */
	public function fetchUserUnit(Request $request){	 
		$user = $request->user_name;
		$user_detail = UserMaster::select('*')->where('user_name', $user)->first();
		$html = '';
		if($user_detail !=''){          
			$userUnit = UserUnit::where('user_id',$user_detail->user_id)->get();
			foreach ($userUnit as $key => $userUnits) {
				if($userUnits->getUnitDetail != null){
					$html .= '<option value='.$userUnits->getUnitDetail->code.'>'.$userUnits->getUnitDetail->name.'('.$userUnits->getUnitDetail->code.')</option>';
				}
			}
       		$status = 1;
		}else{
			$status = 0;
		}
	  	return response()->json(['status' => $status, 'data' => $html]);
    }

	/** 
     * Add the log session data in DB.
     *
     * @return \Illuminate\Http\Response
     */
	public function manageLoginSession($token,$log_data){
		try{
			if (request()->is('loginAction')) {
				//$MAC = exec('getmac');
				//$MAC = strtok($MAC, ' ');
				$user_url = session()->get('_previous');
				$url = request()->ip();
				//dd($url);
				$http_user_agent = $_SERVER['HTTP_USER_AGENT'];
				$csfr = session()->get('_token');
				//$token = @$_REQUEST['_ts'];
        		//$log_user = session()->get($token);
				$user_id = $log_data['id'];
				$unit_code= $log_data['unitcode'];
				$unit_name= $log_data['unitname'];
				$sess_no= $log_data['logtoken'];
				
				$UserSession = new UserSession();
				$UserSession->user_id = $user_id;
				$UserSession->login_time = date('Y-m-d H:i:s');
				$UserSession->session_no = $sess_no;
				$UserSession->machine = $url;
				$UserSession->login_unit = $unit_code;
				$UserSession->http_session_no = $token;
				$UserSession->http_user_agent = $http_user_agent;
				//$UserSession->mac_ip = $MAC;
				$UserSession->success = 'Yes';
				$UserSession->save();
			}elseif(request()->is('logout')){
				//dd(session()->all());
				$csfr = session()->get('_token');

				$UserSession = UserSession::where('http_session_no', $token)->first();
				$UserSession->logout_time = date('Y-m-d H:i:s');
				$UserSession->update();
			}else{
				return redirect('/');
			}
		}catch(Exseption $e){
			return response()->json(['error' => $e->getMessage()]);
		} 
    }


	/** 
     * Manage login permission
     *
     * @return \Illuminate\Http\Response
     */
	public function manageLoginPermission($token,$user_id=''){
		try{
			$log_user = session()->get($token);
			$user_id = $log_user['id'];
			$unit_code = $log_user['unitcode'];

			if (request()->is('loginAction')) {
				$ip = request()->ip();
				$http_user_agent = $_SERVER['HTTP_USER_AGENT'];
				
				$LoginPermission = new LoginPermission();
				$LoginPermission->token = $token;
				$LoginPermission->user_id = $user_id;
				$LoginPermission->login_date_time = date('Y-m-d H:i:s');
				$LoginPermission->ip = $ip;
				$LoginPermission->http_user_agent = $http_user_agent;
				$LoginPermission->current_status = '1';
				$LoginPermission->unit_cd = $unit_code;
				$LoginPermission->save();
			}elseif(request()->is('logout')){
				$csfr = session()->get('_token');

				$logout = LoginPermission::where('token', $token)->first();
				$logout->logout_date_time = date('Y-m-d H:i:s');
				$logout->current_status = '0';
				$logout->update();
			}else{
				return redirect('/');
			}
		}catch(Exseption $e){
			return response()->json(['error' => $e->getMessage()]);
		} 
    }


	/** 
     * Get the log module t-codes
     *
     * @return \Illuminate\Http\Response
     */
	public function getTCodes(Request $request){	 
		$token = @$_REQUEST['_ts'];
        $log_user = session()->get($token);
		$tcode_allow_menus = UserPriv::where('user_id', $log_user['id'])->where(function($q) {
			$q->orWhere('p_add', 'Y')
			  ->orWhere('p_modify', 'Y')
			  ->orWhere('p_view', 'Y')
			  ->orWhere('p_del', 'Y');
		})->pluck('file_id')->toArray();
		//$menus_a = $log_user['allowmenus'];
		
		$tcodes = erpmenumodel::select('file_id','file_type','file_sname','file_menu_id','modl','flow_path','t_code')
			->whereIn('file_id', $tcode_allow_menus)
			->where('t_code', '!=', '')
			->where(function($query) use ($request) {
				$query->orWhere(DB::raw('LOWER(file_master_erp.t_code)'), 'LIKE', '%'.strtolower($request->char).'%');
				$query->orWhere(DB::raw('LOWER(file_master_erp.file_sname)'), 'LIKE', '%'.strtolower($request->char).'%');                  
			}) 
			->get();		
	  	return response()->json(['status' => 1, 'data' => $tcodes]);
    }

	// Get git log from git and save data in database.
	public function CreateGitLog(){
		// get all git developers
		$developers = GitDeveloper::All()->toArray();
		foreach($developers as $developer){
			// get git developers logs
			$output = shell_exec('git log --after="yesterday" --author="'.$developer['developer_name'].'" -p');
			$git_logs = explode('commit ',$output);
			foreach($git_logs as $git_log){
				if($git_log != ''){
					$git_log_data = new GitLog();
					$git_log_data->developer_name = $developer['developer_name'];
					$git_log_data->developer_email = $developer['developer_email'];
					$git_log_data->commit = $git_log;
					$git_log_data->save();
				}
			}
		}
	}
	
	// Get developers by git and create developer in database.
	public function CreateGitDevelopers(){
		$developers = shell_exec('git shortlog -sne --all');
		$developers = explode('     ',$developers);
		array_pop($developers);
		array_shift($developers);
		$d_details = [];
		
		// Delete all git developers
		GitDeveloper::query()->truncate();
		foreach($developers as $developer){
			// Add git developers
			$d_details = new GitDeveloper();
			$data = preg_split('/\t/', $developer);
			$d_details['total_commit'] = $data[0];
			$data = explode('<', $data[1]);
			$d_details['developer_name'] = trim($data[0]);
			$data = preg_split('/\n/', $data[1]);
			$d_details['developer_email'] = str_replace('>','',$data[0]);			
			$d_details->save();
		}
	}

	/** 
     * Get git log by developers wise.
     *
     * @return \Illuminate\Http\Response
     */
	public function gitLogs(){
		$logs = GitDeveloper::with('getCommits')->get();
		return view('gitlog',compact('logs'));
    }

	/** 
     * This function use for run approval proc
     *
	 * @para $p_doc_name, $p_doc_no, $p_amd, $p_doc_st, $p_emp)
     * @return \Illuminate\Http\Response
     */ 
	public function dprApproveDocument(Request $request){
		try{
			$p_doc_name = $request->p_doc_name;
			$p_doc_no = $request->p_doc_no;
			$p_amd = $request->p_amd;
			$p_doc_st = $request->p_doc_st;
			// $p_emp = $request->p_emp;
			$token = @$_REQUEST['_ts'];
        	$p_emp = session()->get($token);
			$p_emp = $p_emp['emp_id'];
			// dd($p_emp);
			$res = DB::select( DB::raw("call dpr_approve_document('$p_doc_name', '$p_doc_no', '$p_amd', '$p_doc_st', '$p_emp');") );
			return response()->json(['error' => 0, 'status' => 1, 'message' => 'Document Approved Successful! '.$p_doc_no]);
		}catch(Exseption $e){
			return response()->json(['error' => 1, 'message' => $e->getMessage()]);
		} 
    }


     /**
	 * This function use for get data
	 *
	 * @return purchase page
	 */
	public function getTableData(Request $request){
		//dd($request->all());
		 $token = @$_REQUEST['_ts'];
        if (session()->exists($token)) {
            $user = session()->get($token);
            
			// Call Procedure here
			$search = array($request->search_field => $request->sea_field_val, 'user_id' => $request->user_id,'ip' => $request->ip, 'unit_cd' => $user['unitcode']);
            $search=array_filter($search, function($value) { return !is_null($value) && $value !== ''; });
            session()->put($token.'.search', $search);
            
            $db_data = LoginPermission::where($search)->orderBy($request->sorting, $request->order)->with('getUser')->paginate($request->per_page); 
			if($request->order == 'ASC'){
                $sorting = 'DESC';
                $sorting_class = 'sorting_desc';
            }else{
                $sorting = 'ASC';
                $sorting_class = 'sorting_asc';
            }

			$count = $db_data->count();

			$number_of_page = $db_data->lastPage();
			$currentPage = $db_data->currentPage();
            $total_items = $db_data->total();
            $displayfrom = ($currentPage-1)*$request->per_page+1;
            $displayto = ($currentPage-1)*$request->per_page+$count;
			$pagination = '';
			//display the pagination
			if($number_of_page > 1){
                $prv = $currentPage-1;
                $next = $currentPage+1;
                if($next > $number_of_page){
                    $next = $number_of_page;
                }
                $pagination .='<div class="pGroup">
                    <div class="pFirst pButton first-button" onclick="return getTableDataByPage(1);">
                    <span></span>
                    </div>
                    <div class="pPrev pButton prev-button" onclick="return getTableDataByPage('.$prv.');">
                    <span></span>
                    </div>
                </div>
                <div class="btnseparator"></div>
                <div class="pGroup">
					<span class="pcontrol">Page <input name="page" type="text" value="'.$currentPage.'" size="4" id="crud_page" class="crud_page">of <span id="last-page-number" class="last-page-number">'.$number_of_page.'</span></span>
                </div>
                <div class="btnseparator"></div>
                <div class="pGroup">
					<div class="pNext pButton next-button" onclick="return getTableDataByPage('.$next.');">
					<span></span>
					</div>
					<div class="pLast pButton last-button" onclick="return getTableDataByPage('.$number_of_page.');">
					<span></span>
					</div>
				</div>';  
			}
			
			//return response()->json(['status' => 0, 'data' => $db_data, 'pagination' => $pagination, 'msg' => 'Data Not Found!']);
			if($count == 0){
				return response()->json(['status' => 0, 'data' => $db_data, 'pagination' => $pagination, 'msg' => 'Data Not Found!']);
			}else{
                $records = '';
                $records .= '<thead>
                <tr class="hDiv">
                    <th>';
                        if($request->sorting == 'user_id'){
                            $records .= '<div class="text-left field-sorting '.$sorting_class.'" field="user_id" order="'.$sorting.'">';
                        }else{
                            $records .= '<div class="text-left field-sorting" field="user_id" order="'.$sorting.'">';
                        }
                        $records .= 'Si.No				
                        </div>
                    </th>
                    <th>';
                        if($request->sorting == 'file_id'){
                            $records .= '<div class="text-left field-sorting '.$sorting_class.'" field="file_id" order="'.$sorting.'">';
                        }else{
                            $records .= '<div class="text-left field-sorting" field="file_id" order="'.$sorting.'">';
                        }
                        $records .= 'User					
                        </div>
                    </th>
					
					<th>';
                        if($request->sorting == 'fr_dt'){
                            $records .= '<div class="text-left field-sorting '.$sorting_class.'"  field="fr_dt" order="'.$sorting.'">';
                        }else{
                            $records .= '<div class="text-left field-sorting"  field="fr_dt" order="'.$sorting.'">';
                        }
                        $records .= 'Token			
                        </div>
                    </th>
                   
                    <th>';
                        if($request->sorting == 'to_dt'){
                            $records .= '<div class="text-left field-sorting '.$sorting_class.'" field="to_dt" order="'.$sorting.'">';
                        }else{
                            $records .= '<div class="text-left field-sorting" field="to_dt" order="'.$sorting.'">';
                        }
                        $records .= 'Login Time				
                        </div>
                    </th>
                    <th>';
                        if($request->sorting == 'to_dt'){
                            $records .= '<div class="text-left field-sorting '.$sorting_class.'" field="to_dt" order="'.$sorting.'">';
                        }else{
                            $records .= '<div class="text-left field-sorting" field="to_dt" order="'.$sorting.'">';
                        }
                        $records .= 'Logout Time			
                        </div>
                    </th>
                    <th>';
                        if($request->sorting == 'to_dt'){
                            $records .= '<div class="text-left field-sorting '.$sorting_class.'" field="to_dt" order="'.$sorting.'">';
                        }else{
                            $records .= '<div class="text-left field-sorting" field="to_dt" order="'.$sorting.'">';
                        }
                        $records .= 'IP			
                        </div>
                    </th>
                    <th>';
                        if($request->sorting == 'to_dt'){
                            $records .= '<div class="text-left field-sorting '.$sorting_class.'" field="to_dt" order="'.$sorting.'">';
                        }else{
                            $records .= '<div class="text-left field-sorting" field="to_dt" order="'.$sorting.'">';
                        }
                        $records .= 'Current Status			
                        </div>
                    </th>
                    <th>';
                        if($request->sorting == 'to_dt'){
                            $records .= '<div class="text-left field-sorting '.$sorting_class.'" field="to_dt" order="'.$sorting.'">';
                        }else{
                            $records .= '<div class="text-left field-sorting" field="to_dt" order="'.$sorting.'">';
                        }
                        $records .= 'Action		
                        </div>
                    </th>
                </tr>
                </thead>
                    <tbody>';
                    $si_no = 1;
                    
                foreach($db_data as $row){
                    $records .= '<tr class="">
                   
                    <td>'.$si_no.'</td>
                    <td>'.$row->getUser['user_name'].' ('.$row['user_id'].')</td>
                    <td>'.$row['token'].'</td>
                    <td>'.$row['login_date_time'].'</td>
                    <td>'.$row['logout_date_time'].'</td>
                    <td>'.$row['ip'].'</td>
                   
                    <td>'.$row['current_status'].'</td>
                    <td><form method="GET" action="'.url('killloginuser/'.$row['token']).'?_ts='.@$_REQUEST['_ts'].'">					
							<input type="hidden" name="_ts" value="'.@$_REQUEST['_ts'].'" />
							<button type="submit" class="flx_btn">Kill</button>
						</form>
						<button type="button" class="flx_btn" data-toggle="modal" data-target=".bd-example-modal-lg" onclick="getDetails('."'".$row['token']."'".')">
							Details
						</button>
					</td>';
                }
                

                $records .= '</tbody>';
                 $si_no++;
            }				
				
			return response()->json(['status' => 1, 'data' => $records, 'msg' => 'This is matched data!']);
		}else{
			return view('login');
		}
		
    }

    /**
	 * This function use for match data
	 *
	 * @return purchase page
	 */
	public function getColumns(Request $request){
        $token = @$_REQUEST['_ts'];
		if (session()->exists($token)) {
			if($request->sessionrest == 1){
                session()->forget($token.'.search');
            }
			
			$records = '<thead>
			<tr class="hDiv">
                <th>
                    <div class="text-left field-sorting">
                   		Si No.			
                    </div>
                </th>
                <th>
                    <div class="text-left field-sorting">
                    	User		
                    </div>
                </th>
                <th>
                    <div class="text-left field-sorting">
                   		Token	
                    </div>
                </th>
                <th>
                    <div class="text-left field-sorting">
                    	Login Time
                    </div>
                </th>
                <th>
                    <div class="text-left field-sorting">
                    	Logout Time
                    </div>
                </th>
                <th>
                    <div class="text-left field-sorting">
                    	IP
                    </div>
                </th>
                <th>
                    <div class="text-left field-sorting">
                    	Current Status
                    </div>
                </th>
                <th>
                    <div class="text-left field-sorting">
                    	Action
                    </div>
                </th>
			</tr>
			</thead>
			<tbody>
				<tr><td colspan="8"><center>Not Any Search Data</center></td></tr>
			</tbody>';
				
			return response()->json(['status' => 1, 'data' => $records, 'msg' => 'Data Not Found!']);
		}else{
			return view('login');
		}
		
    }



    /**
	 * This function use for Logout the user before today's Date
	 *
	 * @return purchase page
	 */
    
    public function logoutUser($token,$userid){


    	$date = today()->format('Y-m-d');
   //  	//dd($date);
		 // $userdata = UserSession::where('login_time', '<', $date)->where(['user_id'=>$userid , 'machine'=> '127.0.0.1'])->whereNull('logout_time')->get();
		 // dd($userdata);

    	
		$post=[
			'logout_time' => date('Y-m-d H:i:s'),
		];

		$update =[
			'logout_date_time'=>date('Y-m-d H:i:s'),
			'current_status' => 0

		];


		$updateTime = UserSession::whereNull('logout_time')->where('login_time', '<', $date)->where(['user_id'=>$userid])->update($post);

		$updateTimepermision = LoginPermission::whereNull('logout_date_time')->where('login_date_time', '<', $date)->where(['user_id'=>$userid])->update($update);
    }
    // public function forget(){
    //     return view('forget-password');  
    // }

	public function DeletefavPage(Request $request){
        $unit_cd = Session::get('unit_cd');
        $emp_id = Session::get('emp_id');
        $fav_menu = FavoriteMenu::where('emp_cd',$emp_id)->where('file_id',$request->fileid)->where('unit_cd',$unit_cd)->first();
		$delete = $fav_menu->delete();
        if($delete){
			return response()->json(['status' => 1, 'message' => 'This favorite has been deleted sucessfully.']);

        }
        else{
			return response()->json(['status' => 0, 'message' => 'Page not added in favorite list!']);    
        }  
	}
	// Notice Board
	//This function use for Save New User 
		public function DescMax(Request $request){
			$value = $request->session()->all();
			$emp_id = Session::get('emp_id');
			$unit_cd = Session::get('unit_cd'); 
	        $data=DB::table('event_announcement_dtl')->where('event_announcement_dtl_id',$request->id)->first();
			if(isset($data)){
				return response()->json(['status' => 1, 'data' => $data]);
			}
			else{
			return response()->json(['status' => 0, 'message' => $e->getMessage(), 'data' => '']);
		
			}
	
		}

	//This function use for birthday wishes send to mail
	public function sendWishes(Request $request){
		$value = $request->session()->all();
		$emp_id = Session::get('emp_id');
		$user_name=Session::get('user_name');
		$unit_cd = Session::get('unit_cd');

		$emp_data_for_email=Emp_Mast_hd::where('emp_number',$request->empcd)->where('unit',$unit_cd)->first();
		$emp_login=Emp_Mast_hd::where('emp_number',$emp_id)->where('unit',$unit_cd)->first();
		
		//randemImages 
		$randimage=(rand(1,10));
		$files = [
			public_path('/assets/img/birthday') . $randimage . '.'. 'gif',
		];
		$image=public_path('/assets/img/birthday') . $randimage . '.'. 'gif';
		$save_email_to = Emp_Mast_hd::where('emp_number',$emp_data_for_email->reporting_to)->where('unit',$unit_cd)->first();
		
		$templateName = 'hrm.emailTemplate.sendWishes';
		
		$emaildata['emp_name']=@$emp_data_for_email->emp_first_name.' '.@$emp_data_for_email->emp_last_name;
		$emaildata['emp_email']=@$emp_data_for_email->company_email;
		$emaildata['emp_number']=$emp_id;
		$emaildata['image']=$image;
		$emaildata['name']=$request->name;
		$emaildata['app_date']=date('d-m-Y');
		$emaildata['remarks']=$request->remarks;
		$emaildata['emp_last_name']=$request->emp_last_name;
		$emaildata['emp_first_name']=$request->emp_first_name;
		$emaildata['date_of_birth']=$request->date_of_birth;
		$emaildata['join_date']=$request->join_date;
		//  $to_email='jyoti@mawaimail.com';
	   $to_email = $emp_data_for_email->company_email;

	   $cc = $emp_login->company_email;
		//  $cc='noreply@mawaimail.com';
		$bcc='noreply@mawaimail.com';
		
		$subject='Birthday wishes From '.@getEmpName($user_name).'('.$emaildata['emp_number'].')';
		$senddata =$emaildata;

		$to_name=@$emp_name;
		$from_email=@$emp_data_for_email->company_email;

		$res=sendEmailGlobal($templateName,$to_email,$subject,$senddata,$cc,$bcc,$to_name,$from_email,$files);
		return response()->json(['status' => 1, 'message' => 'Wish message send Sucessfully.']);
	}		
		
	//This function use for anniversary wishes send to mail
	public function sendAnniversaryWish(Request $request){
		$value = $request->session()->all();
		$emp_id = Session::get('emp_id');
		$user_name=Session::get('user_name');
		$unit_cd = Session::get('unit_cd');

		$emp_data_for_email=Emp_Mast_hd::where('emp_number',$request->empcd)->where('unit',$unit_cd)->first();
		$emp_login=Emp_Mast_hd::where('emp_number',$emp_id)->where('unit',$unit_cd)->first();
		
		//randemImages 
		$randimage=(rand(2,12));
		$files = [
			public_path('/assets/img/anniversary') . $randimage . '.'. 'gif',
		];
		$image=public_path('/assets/img/anniversary') . $randimage . '.'. 'gif';
		$save_email_to = Emp_Mast_hd::where('emp_number',$emp_data_for_email->reporting_to)->where('unit',$unit_cd)->first();
		
		$templateName = 'hrm.emailTemplate.AnniversaryWish';
		
		$emaildata['emp_name']=@$emp_data_for_email->emp_first_name.' '.@$emp_data_for_email->emp_last_name;
		$emaildata['emp_email']=@$emp_data_for_email->company_email;
		$emaildata['emp_number']=$emp_id;
		$emaildata['image']=$image;
		$emaildata['name']=$request->name;
		$emaildata['app_date']=date('d-m-Y');
		$emaildata['remarks']=$request->remarks;
		$emaildata['emp_last_name']=$request->emp_last_name;
		$emaildata['emp_first_name']=$request->emp_first_name;
		$emaildata['date_of_birth']=$request->date_of_birth;
		$emaildata['join_date']=$request->join_date;
		// $to_email='jyoti@mawaimail.com';
		$to_email = $emp_data_for_email->company_email;

	   	$cc = $emp_login->company_email;
		//  $cc='noreply@mawaimail.com';
		$bcc='noreply@mawaimail.com';
		
		$subject='Work Anniversary wishes From '.@getEmpName($user_name).'('.$emaildata['emp_number'].')';
		$senddata =$emaildata;

		$to_name=@$emp_name;
		$from_email=@$emp_data_for_email->company_email;

		$res=sendEmailGlobal($templateName,$to_email,$subject,$senddata,$cc,$bcc,$to_name,$from_email,$files);
		return response()->json(['status' => 1, 'message' => 'Wish message send Sucessfully.']);
	}		
		
}
	
