<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use  App\Models\Subscription;
use  App\Models\Routing;
use  App\Models\CartPackage;
use  App\Models\Cart;
use  App\Models\SPServiceSettings;
use  App\Models\SPRoutingAlert;
use  App\Models\SPRoutingAlertDetail;
use  App\Models\UserAlert;
use  App\Models\SPAlert;
use  App\Models\SPPayment;
use  App\Models\SPPaymentTransaction;
use  App\Models\SPPaymentHistory;
use  App\Models\SubCategoryServiceRule;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Log;
use DB;
use Validator;
use Illuminate\Contracts\Queue\Queue;

class SPPaymentController extends Controller {
    
   
    /**
     * This function use for add sp payment.
     *
     * @return Response
     */
    public function addSPPayment(Request $request){
        $validator = Validator::make($request->all(), [ 
            'subscription_id' => 'required',
            'sp_id' => 'required',
            'transaction_id' => 'required',
            'amount' => 'required',
            'create_by' => 'required'
        ]);
        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }
        
        try {
			
            // add payment
            $SPPaymentHistory = new SPPaymentHistory();
            $SPPaymentHistory->subscription_id = $request->subscription_id;
            $SPPaymentHistory->sp_id = $request->sp_id;
            $SPPaymentHistory->transaction_id = $request->transaction_id;
            $SPPaymentHistory->amount = $request->amount;
            $SPPaymentHistory->comment = $request->comment;
            $SPPaymentHistory->payment_status = 'done';
            $SPPaymentHistory->create_by = $request->create_by;
            $SPPaymentHistory->payment_date = date('Y-m-d, H:i:s');
            $SPPaymentHistory->save();  
            
            

            return response()->json(['status' => 1,'message' => 'Payment Done!', 'data' => $SPPaymentHistory], 200);

        }catch(\Exception $e) {
            return response()->json(['message' => 'Error: '.$e], 500);
        }

    }
    
    /**
     * This function use for get sp payments.
     *
     * @return Response
     */
    public function getSPPayments(Request $request){
        
        try {
            $SPPayment = SPPayment::get();

            return response()->json(['status' => 1,'message' => 'SP Payments!', 'data' => $SPPayment], 200);

        }catch(\Exception $e) {
            return response()->json(['message' => 'Error: '.$e], 500);
        }

    }
    
    
}