<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller as BaseController;
use App\Models\hrm\Attendance;
use App\Models\hrm\RawDataview;
use App\Models\hrm\EmailErrorLogModal;
use App\Models\hrm\Emp_Mast_hd;
use App\Models\hrm\Chat;
use View;
use Carbon\Carbon;
use DB;
use Session;
use DateTime;
use Illuminate\Support\Facades\Http;


class Controller extends BaseController {
    
    public function __construct(){
		//$this->middleware('checklogin');
	}

    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

// get the address via lat and long and return address;
function getAddress($latitude, $longitude)
{
    //return '';
    $apiKey = env('GOOGLE_MAP_KEY_MAWAI_MMS');
    $url = "https://maps.google.com/maps/api/geocode/json?latlng=$latitude,$longitude&key=$apiKey";

    $geocode = file_get_contents($url);
    $json = \json_decode($geocode);

    if($json->status == 'OVER_QUERY_LIMIT')
    {
        $address = ''; 
    }elseif($json->status == 'REQUEST_DENIED'){

        $address = ''; 
    }else{
        $address = $json->results[0]->formatted_address;
    }
    return $address;
}



// calculate distance via lat and long

function getDistanceBetweenTwoCoordinates($lat1, $lon1, $lat2, $lon2, $unit) 
{

        $theta = $lon1 - $lon2;
        $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
        $dist = acos($dist);
        $dist = rad2deg($dist);
        $miles = $dist * 60 * 1.1515;
        $unit = strtoupper($unit);
      
        if ($unit == "K") {
            $dis_diffe = ($miles * 1.609344);
            $dis_diffe = (float) $dis_diffe;
            $dis_diffe = $dis_diffe*1000;
            return $dis_diffe;
        } else if ($unit == "N") {
            return ($miles * 0.8684);
        } else {
            return $miles;
        }
 }

// check late punchin

public function checkLatePunchIn($value)
{    

    $emp_id = $value['emp_id'];
    $unit_cd = $value['unit_cd'];
    $currDate = date('d-M-Y');

    $no_off_punch = Attendance::where('empcode',$emp_id)->whereNotNull('late_punch')->whereMonth('created_at', Carbon::now()->month)->count();
    $allow_late = DB::select("select hrm.get_late_coming_allow('$emp_id','$currDate','$unit_cd')");
    $allow_late = $allow_late[0]->get_late_coming_allow;
    $allow_late = (int) $allow_late;

    if($allow_late < $no_off_punch)
    {
        $cur_time = date('H:i:s');
        $updatedTeamAttn = DB::select("select hrm.get_emp_shift('$emp_id','$currDate','$unit_cd')");
        $shift = $updatedTeamAttn[0]->get_emp_shift;
        if(!empty($shift))
    {
        $shift_allow_time = @getShiftData($shift,$unit_cd)->start_time;
        $late_allow_time = @getShiftData($shift,$unit_cd)->late_punch_allow;
        $hour_allow = date('H',strtotime($late_allow_time));
        $hr_al = (int) $hour_allow;
        $minute_allow = date('i',strtotime($late_allow_time));
        $mi_al = (int) $minute_allow;
        $allow_final_time = $hr_al*60+$mi_al;
        $second_allow = date('s',strtotime($late_allow_time));

        $time1 = new DateTime($cur_time);
        $time2 = new DateTime($shift_allow_time);
        $interval = $time1->diff($time2);
        
        $h = $interval->format('%h');
        $hr = (int) $h;
        $m = $interval->format('%i');
        $mi = (int) $m;
        $s = $interval->format('%s');
       
        if(strlen($h) == 1) { $h = '0'.$h;  }
        if(strlen($m) == 1) { $m = '0'.$m;  }
        if(strlen($s) == 1) { $s = '0'.$s;  }
        $final_time = $hr*60+$mi;
        $data = [];
        $time_data = $h.':'.$m.':'.$s;
        if($final_time >  $allow_final_time)
        {
            $data = ['message' => 'Today your punch is late! Please take care of this','time' =>$time_data];
            return $data;
           
        } 
        else {
            $data = ['message' => '','time' => NULL];
            return $data;
        }


    }
}
    else {
        $data = ['message' => '','time' => NULL];
        return $data;
    }


}


//attedence punch in sms function 
public function IncomingPunchSendSMSGlobal($phone_no,$name,$punchintime,$location,$location1,$value) {

    //dd($phone_no,$name,$punchintime,$location,$location1,$hour_late,$allow_limit,$late_commit);

    $emp_id = trim($value['emp_id']);
    $unit_cd = $value['unit_cd'];
    $currDate = date('d-M-Y');

    $allow_late = DB::select("select hrm.get_late_coming_allow('$emp_id','$currDate','$unit_cd')");
    $allow_late = $allow_late[0]->get_late_coming_allow;
    $allow_late = (int) $allow_late;

    $no_off_punch_late = RawDataview::where('emp_number',$emp_id)->whereNotNull('late_punch')->whereMonth('att_date', Carbon::now()->month)->count();
    
    $username = env("SMS_USERNAME");
    $password = env("SMS_PASSWORD");
    $user_sender = env("SMS_SENDER");
    $entityID = env("SMS_ENTITY_ID");

    $apiURL = "http://nimbusit.co.in/api/swsendSingle.asp?username=$username&password=$password&sender=$user_sender&sendto=$phone_no&entityID=$entityID&templateID=1707166270027032195
    &message=Dear $name, Your incoming punch time is $punchintime and your punching location is $location,$location1.
     This is $no_off_punch_late late coming out of $allow_late limit.
     After $allow_late late comming treated as half day/LWP. Thanks MAWAI";
    $response = Http::get(trim($apiURL));
    $statusCode = $response->status();
    $responseBody = json_decode($response->getBody(), true);
   return $responseBody;
}

//attedence punch OUT sms function 
public function PunchOutSendSMSGlobal($phone_no,$name,$punchintime,$location,$location1,$working_total_hours,$value) {

    $emp_id = trim($value['emp_id']);
    $unit_cd = $value['unit_cd'];
    $currDate = date('d-M-Y');

    $allow_late = DB::select("select hrm.get_late_coming_allow('$emp_id','$currDate','$unit_cd')");
    $allow_late = $allow_late[0]->get_late_coming_allow;
    $allow_late = (int) $allow_late;

    $no_off_punch_late = RawDataview::where('emp_number',$emp_id)->whereNotNull('early_punch')->whereMonth('att_date', Carbon::now()->month)->count();



    $username = env("SMS_USERNAME");
    $password = env("SMS_PASSWORD");
    $user_sender = env("SMS_SENDER");
    $entityID = env("SMS_ENTITY_ID");

    $apiURL = "http://nimbusit.co.in/api/swsendSingle.asp?username=$username&password=$password&sender=$user_sender&sendto=$phone_no&entityID=$entityID&templateID=1707166263944509128&message=Dear $name, Your outgoing punch time is $punchintime and your punching location is $location,$location1.
    This is $no_off_punch_late early out of $allow_late limit. After $allow_late early out treated as half day/LWP.
     Today woking hour is $working_total_hours. Thanks MAWAI";

    $response = Http::get(trim($apiURL));
    $statusCode = $response->status();
    $responseBody = json_decode($response->getBody(), true);
   return $responseBody;
}

public function emailErrorLog($to_email=null,$cc=null,$bcc=null,$error_msg=null,$emp_cd=null,$email_status=null,$unit_cd=null){

    if($error_msg==true){
        $error_msg='Email Send Sucessfully';
        $mail_status='Sucess';
    }else{
        $error_msg=$error_msg;
        $mail_status='Error';
    }
  
    if($cc=='noreply@mawaimail.com'){
      $cc='';
    }else{
      $cc= $cc;
    }
    if($bcc=='noreply@mawaimail.com'){
        $bcc='';
      }else{
        $bcc= $bcc;
      }
    
   $c= json_encode(['to' => $to_email, 'cc' => $cc, 'bcc' =>$bcc]);
     //return $c;
     $log['email_ids']=$c;
     $log['error_description']=$error_msg;
     $log['mail_type']=$email_status;
     $log['mail_date']=date('Y-m-d H:i:s');
     $log['mail_status']=$mail_status;
     $log['emp_number']=$emp_cd;
     $log['unit_cd']=$unit_cd;
     $log['user_system_name']=gethostname();
     $log['created_by']=$emp_cd;
     $log['creation_date']=date('Y-m-d H:i:s');
     $res= EmailErrorLogModal::insert($log);
     return $res;
}


    // Save attendance data in oracle db
    public function saveDataInOracleDB($ENG_CD, $FULLDATE, $PUNCH_TIME, $LONGITUDE, $LATITUDE, $ADDRESS, $PUNCH_TYPE, $P_TYPE, $ENTRY_DATE, $PUNCH_DATETIME){
        $check_data = DB::connection('oracle')->table('VEGA_ATT_APIDATA')->where('ENG_CD', $ENG_CD)->where('PUNCH_DATETIME', $PUNCH_DATETIME)->where('P_TYPE', $P_TYPE)->where('PUNCH_TYPE', $PUNCH_TYPE)->count();

        if($check_data < 1){
            $attendance = DB::connection('oracle')->table('VEGA_ATT_APIDATA')->insert(["ENG_CD" => $ENG_CD, "FULLDATE" => $FULLDATE, "PUNCH_TIME" => $PUNCH_TIME, "LONGITUDE" => $LONGITUDE, "LATITUDE" => $LATITUDE, "ADDRESS" => $ADDRESS, "PUNCH_TYPE" => $PUNCH_TYPE, "P_TYPE" => $P_TYPE, "ENTRY_DATE" => $ENTRY_DATE, "PUNCH_DATETIME" => $PUNCH_DATETIME]);
        }
        return true;
    }
    
}
