<?php
use App\Models\hrm\Emp_Mast_hd;
use App\Models\hrm\Department;
use App\Models\hrm\Attendance;
use App\Models\LeaveMaster;
use App\Models\EmpLeaveMast;
use App\Models\CategoryMaster;
use App\Models\DesignationMaster;
use App\Models\DepartmentMaster;
use App\Models\NationMaster;
use App\Models\hrm\ShiftMaster;
use App\Models\LevelMaster;
use App\Models\StateMaster;
use App\Models\CityMaster;
use App\Models\SecControlVal;
use App\Models\hrm\MissPunchModel;
use App\Models\hrm\FileMaster;
use App\Models\LeaveDetails;
use App\Models\Unit;
use App\Models\UserUnit;
use App\Models\hrm\OtherApprovalConfig;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Http;
use App\Models\hrm\celint_master;
use App\Models\hrm\sap_module_dtl;
use App\Models\hrm\sub_module;

if (!function_exists('getEmpName')) {
    function getEmpName($id) {
        
        $res=Emp_Mast_hd::where('emp_number',$id)->first();
       
        @$name=$res->emp_first_name.' '.$res->emp_last_name;
        return $name;
    }
}

if (!function_exists('getDepartmentName')) {
    function getDepartmentName($code) {
        $res=Department::where('code',$code)->first();
        @$name=$res->name;
        return $name;
    }
}

if (!function_exists('getUnitDesc')) {
    function getUnitDesc($id) {
        $res=Unit::where('code',$id)->first();
        @$name=$res->name;
        return $name;
    }
}


if (!function_exists('getDesignationName')) {
    function getDesignationName($code) {
        $res=DesignationMaster::where('code',$code)->first();
        @$name=$res->description;
        return $name;
    }
}

if (!function_exists('getCategoryName')) {
    function getCategoryName($code) {
        $res=CategoryMaster::where('code',$code)->first();
        @$name=$res->description;
        return $name;
    }
}

if (!function_exists('getMaritalStatus')) {
    function getMaritalStatus($code) {
        $res=SecControlVal::where('control_type','MARITAL_STATUS')->where('control_code',$code)->first();
        @$name=$res->description;
        return $name;
    }
}
if (!function_exists('getLevelDesc')) {
    function getLevelDesc($code) {
        $res=LevelMaster::where('lvl_mast_level',$code)->first();
        @$name=$res->description;
        return $name;
    }
}
if (!function_exists('getAreaDesc')) {
    function getAreaDesc($code) {
        $res=SecControlVal::where('control_type','AREA_CD')->where('control_code',$code)->first();
        @$name=$res->description;
        return $name;
    }
}

if (!function_exists('getStatus')) {
    function getStatus($code) {
        $res=SecControlVal::where('control_type','STATUS1')->where('control_code',$code)->first();
        @$name=$res->description;
        return $name;
    }
}
if (!function_exists('getSecControlValue')) {
    function getSecControlValue($control_code,$control_type) {
        $sec_control_val=SecControlVal::where('control_code',$control_code)->where('control_type',$control_type)->get();
        @$sec_control_val;
        return $sec_control_val;
    }
}

if (!function_exists('getNationName')) {
    function getNationName($code) {
        $res=NationMaster::where('code',$code)->first();
        @$name=$res->description;
        return $name;
    }
}

if (!function_exists('getStateName')) {
    function getStateName($code) {
        $res=StateMaster::where('code',$code)->first();
        @$name=$res->name;
        return $name;
    }
}

if (!function_exists('getShiftDesc')) {
    function getShiftDesc($code) {
        $res=ShiftMaster::where('shift_code',$code)->first();
        @$st=$res->start_time;
        @$end=$res->end_time;
        return 'Start: '.$st. ' End: '.$end;
    }
}

if (!function_exists('getCityName')) {
    function getCityName($code) {
        $res=CityMaster::where('code',$code)->first();
        @$name=$res->name;
        return $name;
    }
}

if (!function_exists('getLeaveDescription')) {
    function getLeaveDescription($code) {
        $res=LeaveMaster::where('code',$code)->first();
        @$name=$res->description;
        return $name;
    }
}


if (!function_exists('getPunchInTime')) {
    function getPunchInTime($emp_cd,$attd_dt,$unit_cd) {
        $res=Attendance::select('address')->where('p_type','I')
        ->where('empcode',$emp_cd)
        ->where('unit_cd',$unit_cd)
        ->whereDate('officepunch',$attd_dt)
        ->first();
        @$name=$res->address;
        return $name;
    }
}

if (!function_exists('getPunchOutTime')) {
    function getPunchOutTime($emp_cd,$attd_dt,$unit_cd) {
        $res=Attendance::select('address')->where('p_type','O')
        ->where('empcode',$emp_cd)
        ->where('unit_cd',$unit_cd)
        ->whereDate('officepunch',$attd_dt)
        ->first();
        @$name=$res->address;
        return $name;
    }
}

if (!function_exists('checkPunchInOrNot')) {
    function checkPunchInOrNot($emp_cd,$attd_dt,$unit_cd) {
        $res=Attendance::select('address')->where('p_type','I')
        ->where('empcode',$emp_cd)
        ->where('unit_cd',$unit_cd)
        ->whereDate('officepunch',$attd_dt)
        ->count();
        if($res>0){
         return true;
        }else{
            return false;
        }
    }
}

if (!function_exists('checkPunchOutOrNot')) {
    function checkPunchOutOrNot($emp_cd,$attd_dt,$unit_cd) {
        $res=Attendance::select('address')->where('p_type','O')
        ->where('empcode',$emp_cd)
        ->where('unit_cd',$unit_cd)
        ->whereDate('officepunch',$attd_dt)
        ->count();
        if($res>0){
         return true;
        }else{
            return false;
        }
    }
}


if (!function_exists('getTotalLeave')) {
    function getTotalLeave($unit_cd,$emp_id,$leave_code) {
        $current_year=date('Y');
        $res=EmpLeaveMast::where('unit_cd',$unit_cd)
        ->where('empmemb_emp_master_emp_number',$emp_id)
        ->where('leave_desc_leave_desc_type',$leave_code)
        ->whereYear('start_date',$current_year)
        ->first();

        @$total_leave=$res->credit_leave+$res->curr_year_leave;
        return $total_leave;
    }
}

if (!function_exists('getUsedLeave')) {
    function getUsedLeave($unit_cd,$emp_id,$leave_code) {
        $current_year=date('Y');
        $res=EmpLeaveMast::where('unit_cd',$unit_cd)
        ->where('empmemb_emp_master_emp_number',$emp_id)
        ->where('leave_desc_leave_desc_type',$leave_code)
        ->whereYear('start_date',$current_year)
        ->first();
        $current_yr= date('Y');
        if($leave_code=='LW'){
            $pending_leave=LeaveDetails::where('leave_desc_leave_desc_type',$leave_code)
            ->where('empmemb_emp_master_emp_number',$emp_id)
            ->whereIn('leave_granted',['P','A'])
            ->whereYear('from_date',$current_yr)
            ->sum('leave_days');
        }else{
            $pending_leave=LeaveDetails::where('leave_desc_leave_desc_type',$leave_code)
            ->where('empmemb_emp_master_emp_number',$emp_id)
            ->where('leave_granted','P')
            ->whereYear('from_date',$current_yr)
            ->sum('leave_days');
        }
    
        @$used_leave=$res->leave_availed+$pending_leave;
        return $used_leave;
    }
}


if (!function_exists('getAvailedLeave')) {
    function getAvailedLeave($unit_cd,$emp_id,$leave_code) {
        $current_year=date('Y');
        $res=EmpLeaveMast::where('unit_cd',$unit_cd)
        ->where('empmemb_emp_master_emp_number',$emp_id)
        ->where('leave_desc_leave_desc_type',$leave_code)
        ->whereYear('start_date',$current_year)
        ->first();
        $current_yr= date('Y');
        $pending_leave=LeaveDetails::where('leave_desc_leave_desc_type',$leave_code)
        ->where('empmemb_emp_master_emp_number',$emp_id)
        ->where('leave_granted','P')
        ->whereYear('from_date',$current_yr)
        ->sum('leave_days');

        @$available_leave=($res->credit_leave+$res->curr_year_leave)-($res->leave_availed+$pending_leave);
        return $available_leave;
    }
}

// get current fin year
if (!function_exists('getCurrentFinYear')) {
    function getCurrentFinYear() {
        $res=DB::table('fin_year')->select('fin_year_code')->where('default_fin_year','YES')->first();
        return $res->fin_year_code;
    }
}


if (!function_exists('getLeaveDesc')) {
    function getLeaveDesc($id) {
        $res=LeaveMaster::where('code',$id)->first();
        return $res->description;
    }
}


if (!function_exists('getShiftData')) {
    function getShiftData($id,$unit) {
        $res=ShiftMaster::select('start_time','end_time','late_punch_allow')->where('shift_code',$id)->where('unit_cd',$unit)->first();
        return $res;
    }
}



if (!function_exists('getEmpEmail')) {
    function getEmpEmail($id) {
        $res=Emp_Mast_hd::where('emp_number',$id)->first();
        @$name=$res->per_emailid;
        return $name;
    }
}

if (!function_exists('getEmpLocation')) {
    function getEmpLocation($id) {
        $res=Emp_Mast_hd::where('emp_number',$id)->first();
        @$name=$res->location;
        return $name;
    }
}

if (!function_exists('getEmpDept')) {
    function getEmpDept($id) {
        $res = DB::table('emp_master_hd')
            ->join('department', 'emp_master_hd.area_mast_department_code', '=', 'department.code')
            ->select('department.name','department.code')
            ->where('emp_master_hd.emp_number',$id)
            ->first();

        return $res;
    }
}

if (!function_exists('getEmpDesig')) {
    function getEmpDesig($id) {
        $unit_cd = Session::get('unit_cd');
        $res = DB::table('emp_master_hd')
            ->join('designation', 'emp_master_hd.desig_code', '=', 'designation.code')
            ->select('designation.description','designation.code')
            ->where('emp_master_hd.emp_number',$id)
            ->first();

        return $res;
    }
}

if (!function_exists('getMissedData')) {
    function getMissedData($in_out_tp,$emp_no,$att_date,$unit) {
        $res=MissPunchModel::where('mis_punch_type',$in_out_tp)
        ->where('empmemb_emp_master_emp_number',$emp_no)
        ->whereDate('mis_punch_date', date('Y-m-d',strtotime($att_date)))
        ->where('unit_cd',$unit)
        ->first();
    
        return @$res;
    }
}



if (!function_exists('getFileName')) {
    function getFileName($id) {
        $res=FileMaster::where('file_id',$id)
        ->first();
    
        @$name=$res->file_name;
        return $name;
    }
}



if (!function_exists('getClientName')) {
    function getClientName($id) {
        $res=DB::table('celint_master')->where('client_cd',$id)
        ->first();
    
        @$name=$res->client_name;
        return $name;
    }
}


if (!function_exists('checkEmpLeave')) {
    function checkEmpLeave($unit_cd,$emp_cd,$leave_cd) {
        $res=EmpLeaveMast::where('empmemb_emp_master_emp_number',$emp_cd)
        ->where('leave_desc_leave_desc_type',$leave_cd)
        ->where('unit_cd',$unit_cd)
        ->first();
        return $res;
    }
}

if (!function_exists('getShiftInData')) {
    function getShiftInData($emp_cd,$date,$unit_cd) {
        $res=Emp_Mast_hd::select('shift')->where('emp_number',$emp_cd)
        ->where('unit',$unit_cd)
        ->first();

     $inAttend=   Attendance::select('officepunch')
     ->where('empcode',$emp_cd)
     ->where('unit_cd',$unit_cd)
     ->where('p_type','I')
     ->whereDate('officepunch',$date)
     ->first();
     if($inAttend==null){
        $shift_time=ShiftMaster::where('shift_code',$res['shift'])->where('unit_cd',$unit_cd)->first();
        $data['intime']= $shift_time['start_time'];
        $data['status']='N';
     }else{
        $data['intime']= date('H:i:s',strtotime($inAttend['officepunch']));
       $data['status']='P';
     }
     return $data;
        
    }
}

if (!function_exists('getShiftOutData')) {
    function getShiftOutData($emp_cd,$date,$unit_cd) {
        $res=Emp_Mast_hd::select('shift')->where('emp_number',$emp_cd)
        ->where('unit',$unit_cd)
        ->first();

     $inAttend=   Attendance::select('officepunch')
     ->where('empcode',$emp_cd)
     ->where('unit_cd',$unit_cd)
     ->where('p_type','O')
     ->whereDate('officepunch',$date)
     ->first();
     if($inAttend==null){
        $shift_time=ShiftMaster::where('shift_code',$res['shift'])->where('unit_cd',$unit_cd)->first();
        $data['outtime']= $shift_time['end_time'];
        $data['status']='N';
       
     }else{
        $data['outtime']= date('H:i:s',strtotime($inAttend['officepunch']));
       $data['status']='P';

        
     }
     return $data;
        
    }
}



if (!function_exists('sendEmailGlobal')) {
    function sendEmailGlobal($template=null,$to_email=null,$subject=null,$data=null,$cc=null,$bcc=null,$to_name=null,$from_email=null,$files=null) {
        // dd($files);
        //dd($template,$to_email,$subject,$data,$cc,$bcc,$to_name,$from_email);
       
try{
     $from_emails= env('MAIL_FROM_EMAIL');
     $from_subject='Mawai Infotech Limited';
     //dd($template,$to_email,$subject,$data,$cc,$bcc,$to_name,$from_email);
     if($files == '' || $files == null){

        

        if($bcc != '' && $cc != ''){
            //dd($template,$to_email,$subject,$data,$cc,$bcc,$to_name,$from_email);
            $res= Mail::send($template, $data, function($message) use ($to_name, $to_email,$subject,$from_emails,$cc,$bcc,$from_subject) {
                $message->to($to_email, $to_name)
                        ->cc($cc)
                        ->bcc($bcc)
                        ->subject($subject);
                $message->from($from_emails, $from_subject);
            });
        }elseif($bcc == '' && $cc != ''){
            $res= Mail::send($template, $data, function($message) use ($to_name, $to_email,$subject,$from_emails,$cc,$from_subject) {
                $message->to($to_email, $to_name)
                        ->cc($cc)
                        ->subject($subject);
                $message->from($from_emails, $from_subject);
            });
        }else{
        
            $res= Mail::send($template, $data, function($message) use ($to_name, $to_email,$subject,$from_emails,$from_subject) {
                $message->to($to_email, $to_name)
                        ->subject($subject);
                $message->from($from_emails, $from_subject);
            });
        }
     }else{
        
        if($bcc != '' && $cc != ''){
            $res= Mail::send($template, $data, function($message) use ($to_name, $to_email,$subject,$from_emails,$cc,$bcc,$from_subject,$files) {
                $message->to($to_email, $to_name)
                        ->cc($cc)
                        ->bcc($bcc)
                        ->subject($subject);
                $message->from($from_emails, $from_subject);
                foreach ($files as $file){
                    $message->attach($file);
                }
            });
        }elseif($bcc == '' && $cc != ''){
            $res= Mail::send($template, $data, function($message) use ($to_name, $to_email,$subject,$from_emails,$cc,$from_subject,$files) {
                $message->to($to_email, $to_name)
                        ->cc($cc)
                        ->subject($subject);
                $message->from($from_emails, $from_subject);
                foreach ($files as $file){
                    $message->attach($file);
                }
            });


        }else{
        
            $res= Mail::send($template, $data, function($message) use ($to_name, $to_email,$subject,$from_emails,$from_subject,$files) {
                $message->to($to_email, $to_name)
                        ->subject($subject);
                $message->from($from_emails, $from_subject);
                foreach ($files as $file){
                    $message->attach($file);
                }
            });
        }
     }
    //    dd(Mail::failures());
//var_dump($res);
        if (Mail::failures()) {
            // return failed mails
            return new Error(Mail::failures()); 
        }else{
            return true;
        }
    }catch(Exception $e) {
        return $e->getMessage();
          }
    }

   
}


if (!function_exists('getWFHCondition')) {
    function getWFHCondition($code) {
        $res=SecControlVal::where('control_type','WFH_CONDITION')->where('control_code',$code)->first();
        @$name=$res->description;
        return $name;
    }
}


if (!function_exists('sendSMSGlobal')) {
    function sendSMSGlobal($code) {
        $apiURL = 'http://nimbusit.co.in/api/swsendSingle.asp?username=t1termserpapi&password=34682252&sender=MAWAII&sendto=7376578914&entityID=1701160760144714503&templateID=1707166263944509128&message=Dear sarvan, Your outgoing punch time is 05:35 AM and your punching location is A-164,SECTOR 63.This is 1 early out of 3 limit. After 3 early out treated as half day/LWP. Today woking hour is 8.00. Thanks MAWAI';
        $response = Http::get($apiURL);
        $statusCode = $response->status();
        $responseBody = json_decode($response->getBody(), true);
        return true;
    }
}

if (!function_exists('getRoleType')) {
    function getRoleType($code) {
        $res=SecControlVal::where('control_type','ROLL_TYPE')->where('control_code',$code)->first();
        @$name=$res->description;
        return $name;
    }
}


if (!function_exists('getDepartmentNameByEmpCode')) {
    function getDepartmentNameByEmpCode($emp_cd) {
        $unit_cd = Session::get('unit_cd');
        $res=DB::table('emp_master_hd')
        ->join('department', 'emp_master_hd.area_mast_department_code', '=', 'department.code')
        ->select('department.name','department.code')
        ->where('department.unit_cd',$unit_cd)
        ->where('emp_master_hd.unit',$unit_cd)
        ->where('emp_master_hd.emp_number',$emp_cd)
        ->first();
        return $res;
    }
}

if (!function_exists('getInImageWarningCheckedValue')) {
    function getInImageWarningCheckedValue($rwdataid, $type) {
        $unit_cd = Session::get('unit_cd');
        if($type == 'I'){
            $res=DB::table('rawdata_app')
            ->select('in_suspicious_flag')
            ->where('unit_cd',$unit_cd)
            ->where('rawdata_app_id',$rwdataid)
            ->first()->in_suspicious_flag;
        }elseif($type == 'O'){
            $res=DB::table('rawdata_app')
            ->select('out_suspicious_flag')
            ->where('unit_cd',$unit_cd)
            ->where('rawdata_app_id',$rwdataid)
            ->first()->out_suspicious_flag;
        }
        return $res;
        // dd($res);
    }
}


if (!function_exists('OtherApprovalConfig')) {
    function OtherApprovalConfig($type_cd) {
        $unit_cd = Session::get('unit_cd');
        $emp_id = Session::get('emp_id');
        $dept_cd = Session::get('dept_cd');
       $res=OtherApprovalConfig::where('department_cd',$dept_cd)
       ->where('auth_cd',$emp_id)
       ->where('unit_cd',$unit_cd)
       ->where('type_cd',$type_cd)
       ->where('active_status','ACTIVE')
       ->count('auth_cd');
        return $res;
    }
}


// No to word convert
if (!function_exists('numberTowords')) {
    function numberTowords($amount){
        $number=$amount;
        $a=explode('.',$number);
        $no = floor($a[0]);
        $point = @$a[1];
        $hundred = null;
        $digits_1 = strlen($no);
        $i = 0;
        $str = array();
        $words = array('0' => 'Zero', '1' => 'One', '2' => 'Two',
            '3' => 'Three', '4' => 'Four', '5' => 'Five', '6' => 'Six',
            '7' => 'Seven', '8' => 'Eight', '9' => 'Nine',
            '10' => 'Ten', '11' => 'Eleven', '12' => 'Twelve',
            '13' => 'Thirteen', '14' => 'Fourteen',
            '15' => 'Fifteen', '16' => 'Sixteen', '17' => 'Seventeen',
            '18' => 'Eighteen', '19' =>'Nineteen', '20' => 'Twenty',
            '30' => 'Thirty', '40' => 'Forty', '50' => 'Fifty',
            '60' => 'Sixty', '70' => 'Seventy',
            '80' => 'Eighty', '90' => 'Ninety');
        $digits = array('', 'Hundred', 'Thousand', 'Lakh', 'Crore');
        while ($i < $digits_1) {
            $divider = ($i == 2) ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += ($divider == 10) ? 1 : 2;
            if ($number) {
                $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                if($number % 10 == 0){
                    $str [] = ($number < 21) ? $words[$number] .
                    " " . $digits[$counter] . $plural . " " . $hundred
                    :
                    $words[floor($number / 10) * 10]
                    . " "
                    . $digits[$counter] . $plural . " " . $hundred;
                }else{
                    $str [] = ($number < 21) ? $words[$number] .
                    " " . $digits[$counter] . $plural . " " . $hundred
                    :
                    $words[floor($number / 10) * 10]
                    . " " . $words[$number % 10] . " "
                    . $digits[$counter] . $plural . " " . $hundred;
                    
                }
                    
               
            } else $str[] = null;
        }
        $str = array_reverse($str);
        $result = implode('', $str);
        if(@$point[0]==0){
            $points = ($point) ? $words[$point / 10] . " " . $words[$point = $point % 10] : '';
        }else if(@$point[1]==0){
            $points = ($point) ? $words[$point = $point % 10]. " " .$words[$point / 10] : '' ;
        }else{
            $points = ($point) ? $words[$point / 10] . " " . $words[$point = $point % 10] : '';
        }
        $get_paise='';
        if($result && $points){
            $get_paise= $result . ' Rupees and ' . $points . ' Paise Only';
        }else if($points){
            $get_paise= 'Zero Rupees and ' . $points . ' Paise Only';
        }else if($result){
            $get_paise= $result . ' Rupees Only';
        }
        return $get_paise;
    }
}

if (!function_exists('client_data')) {
    function client_data($vertical) {
        $unit_cd = Session::get('unit_cd');
        $clint_data=celint_master::where('erp_vert',$vertical)->where('unit_cd',$unit_cd)->get();
        return $clint_data;
    }
}


if (!function_exists('sap_module_dtl')) {
    function sap_module_dtl($vertical) {
        $unit_cd = Session::get('unit_cd');
        $module_data=sap_module_dtl::where('dept_module',$vertical)->where('unit_cd',$unit_cd)->get();
        return $module_data;
    }
}

if (!function_exists('sub_module')) {
    function sub_module($vertical) {
        $unit_cd = Session::get('unit_cd');
        $sub_module=sub_module::where('erp',$vertical)->where('unit_cd',$unit_cd)->get();
        return $sub_module;
    }
}

if (!function_exists('emp_lv_mast_data')) {
    function emp_lv_mast_data($emp_cd,$unit_cd) {
        $unit_cd = Session::get('unit_cd');
        $sub_module=EmpLeaveMast::where('empmemb_emp_master_emp_number',$emp_cd)->where('unit_cd',$unit_cd)->get();
        if(count($sub_module)>0){
            return $sub_module;
        }else{
            return 0;
        }
     
    }
}

if (!function_exists('emp_pendingLv_sum')) {
    function emp_pendingLv_sum($emp_cd,$leave_code) {
        $unit_cd = Session::get('unit_cd');
        $current_yr= date('Y');
        $pending_leave=LeaveDetails::where('leave_desc_leave_desc_type',$leave_code)
        ->where('empmemb_emp_master_emp_number',$emp_cd)
        ->where('leave_granted','P')
        ->whereNotIn('leave_desc_leave_desc_type',['LW','SH'])
        ->whereYear('from_date',$current_yr)
        ->sum('leave_days');
            return $pending_leave;
       
     
    }
}

if (!function_exists('cleintNAme')) {
    function cleintNAme($client_cd) {
        $unit_cd = Session::get('unit_cd');
        $current_yr= date('Y');
        $ab=DB::table('celint_master')->select('client_cd','client_name')->where('client_cd',$client_cd);
        $name_of_org=DB::table('celint_master_hw')->select('client_cd','client_name')
        ->where('client_cd',$client_cd)
        ->union($ab)->first();
            return $name_of_org->client_name;
       
     
    }
}







?>