<?php

namespace App\Export;
use DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Illuminate\Support\Collection;
use App\Models\hrm\TeamWiseAttendanceView;
use App\Models\hrm\MonthWiseAttendanceView;
use App\Models\hrm\Attendance;
use App\Models\hrm\Emp_Mast_hd;
use App\Models\hrm\ShiftMaster;
use Session;
class myAttendanceExcel implements FromCollection,WithHeadings,WithCustomStartCell
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $emp_id = Session::get('emp_id');
        $fin_year = Session::get('fin_year');
        $unit_cd = Session::get('unit_cd');
        $current_dt= date('d-M-Y');
        $currentMonth = strtoupper(date('M'));
        $mon = request()->mon;
        if($mon != '')
        {
            $attendancess =  MonthWiseAttendanceView::where('emp_number',$emp_id)->where('mon',$mon)->get();
        }
        else {
            $attendancess =  MonthWiseAttendanceView::where('emp_number',$emp_id)->where('mon',$currentMonth)->get();
        }
 
		$datas = [];
		
foreach($attendancess as $attendance)
{
			$x = new \stdClass();


			$x->date = !empty($attendance->att_date) ? date('d-m-Y',strtotime($attendance->att_date)) : '';

			$x->punchin =!empty($attendance->in_time) ? date('H:i:s A',strtotime($attendance->in_time)) : 'N/A';

            $x->inAddress =!empty($attendance->in_address) ? $attendance->in_address : 'N/A';

            $x->punchout =!empty($attendance->out_time) ? date('H:i:s A',strtotime($attendance->out_time)) : 'N/A';

            $x->outAddress =!empty($attendance->out_address) ? $attendance->out_address : 'N/A'; 
            $x->tot_time = $attendance->tot_time;
			$x->shift_in = !empty($attendance->shift_cd) ? date('H:i A',strtotime(@getShiftData($attendance->shift_cd,$attendance->unit_cd)->start_time)) : 'N/A';
            $x->shift_out = !empty($attendance->shift_cd) ? date('H:i A',strtotime(@getShiftData($attendance->shift_cd,$attendance->unit_cd)->end_time)) : 'N/A';
			array_push($datas,$x);
    }
		
		
		$collection = Collection::make($datas);
		return $collection;
    }


    public function headings(): array{
        $unit_cd = Session::get('unit_cd');
        $unit_name = Session::get('unit_name');
       $unit_code = $unit_cd;
       $unitname = $unit_name;
       return [
               ['Company Name', $unitname],
               ['Unit Code', $unit_code],
               [''],
               ['Date','Punch In Time','Punch In Add','Punch Out Time','Punch Out Add','Shift Start','Shift End']
           ];
    }


   public function startCell(): string{
       return 'A2';
   }
}

?>