<?php

namespace App\Export;
use DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Illuminate\Support\Collection;
use App\Models\hrm\TeamWiseAttendanceView;
use App\Models\hrm\Emp_Mast_hd;
use Session;
class TeamAttendanceExcel implements FromCollection,WithHeadings,WithCustomStartCell
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $emp_id = Session::get('emp_id');
        $fin_year = Session::get('fin_year');
        $unit_cd = Session::get('unit_cd');
        $current_dt= date('d-M-Y');

        $mon = request()->mon;
     
        $emp_number = request()->emp_number;
        $year = request()->year;
        if($mon != '' && $emp_number != '' && $year != '')
        {
        $teamAttends = TeamWiseAttendanceView::where('reporting_to',$emp_id)->where('unit_cd', $unit_cd)->where('emp_number', $emp_number)->where('mon',$mon)->where('yr', $year)->get();
        }
        else {
            $teamAttends = TeamWiseAttendanceView::where('reporting_to',$emp_id)->where('mon',$mon)->where('unit_cd', $unit_cd)->get();
        }
		$datas = [];
		
		foreach($teamAttends as $dt){
			$x = new \stdClass();

            $inAddress = !empty($dt->in_address) ? str_replace(", Noida, Uttar Pradesh 201301, India","",$dt->in_address) : '';
            //str_replace(", Noida, Uttar Pradesh 201301, India","",$attendances['inAddress'][$j]->address);
            $inAddress = str_replace("WAJIDPUR, SEC.63,","",$inAddress);
            $outAddress = !empty($dt->out_address) ? str_replace(", Noida, Uttar Pradesh 201301, India","",$dt->out_address) : ""; 
            $outAddress = str_replace("WAJIDPUR, SEC.63,","",$outAddress); 

			$x->emp_name = @getEmpName($dt->emp_number);
			$x->emp_number =$dt->emp_number;
            $x->dept_code =@getDepartmentName($dt->dept_code);
            $x->att_date =!empty($dt->att_date) ? date('d-m-Y',strtotime($dt->att_date)) : '';
            $x->in_time =!empty($dt->in_time) ? date('H:i A',strtotime($dt->in_time)) : '';
            $x->in_address = $inAddress;
            $x->out_time =!empty($dt->out_time) ? date('H:i A',strtotime($dt->out_time)) : '';
			$x->out_address = $outAddress;
            $x->totl_hrs = $dt->tot_time;
			array_push($datas,$x);
		}
		
		$collection = Collection::make($datas);
		return $collection;
    }


    public function headings(): array{
        $unit_cd = Session::get('unit_cd');
        $unit_name = Session::get('unit_name');
       $unit_code = $unit_cd;
       $unitname = $unit_name;
       return [
               ['Company Name', $unitname],
               ['Unit Code', $unit_code],
               [''],
               ['Employee Name','Emplyoee Code','Department','Att date','In Time','In Address','Out Time','Out Address','Total Hrs']
           ];
    }


   public function startCell(): string{
       return 'A2';
   }
}

?>