<?php

namespace App\Export;
use DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Illuminate\Support\Collection;
use App\Models\hrm\MissPunchModel;
use App\Models\hrm\Emp_Mast_hd;
use Session;
class MyMissPunchExport implements FromCollection,WithHeadings,WithCustomStartCell
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $emp_id = Session::get('emp_id');
        $fin_year = Session::get('fin_year');
        $unit_cd = Session::get('unit_cd');
         
        $last_30_day_dt = date('d-M-Y', strtotime('-30 days'));
        $current_dt= date('d-M-Y');
         $current_month= date('m');
         



        $row_data = DB::select("SELECT hrm.emp_rawdata_insert('$last_30_day_dt','$current_dt',null,null,null,'$unit_cd','$emp_id')");
        $all_raw_data=$row_data[0]->emp_rawdata_insert;
         $emp_data=Emp_Mast_hd::where('unit',$unit_cd)->where('reporting_to',$emp_id)->pluck('emp_number');
        $res=MissPunchModel::where('empmemb_emp_master_emp_number',$emp_id)->whereMonth('mis_punch_date',$current_month)->where('unit_cd',$unit_cd)->orderBy('mis_punch_date','DESC')->get();
       // dd($res);
		$datas = [];
		
		foreach($res as $row){
			$x = new \stdClass();
      $emp_nm=getEmpName($row->empmemb_emp_master_emp_number);
      $emp_dept=getEmpDept($row->empmemb_emp_master_emp_number);
      $name=@$emp_dept->name;
      $code=@$emp_dept->code;
      $emp_desig=getEmpDesig($row->empmemb_emp_master_emp_number);
      $description=@$emp_desig->description;
      $codes=@$emp_desig->code;
      if($row->mis_punch_type=='I'){
        $in_out='IN-Time';
      }elseif($row->mis_punch_type=='O'){
       $in_out='OUT-Time';
      }elseif($row->mis_punch_type=='B'){
       $in_out='Both';
      }
      $empp_name= getEmpName(@$row->apr_by);
      $x->empmemb_emp_master_emp_name = $emp_nm;
      $x->emp_dept =$name .'('.$code .')';
      $x->emp_desig =$description.'('.$codes.')';
      $x->app_date =date('d-m-Y', strtotime($row->app_date));
      $x->mis_punch_date =date('d-m-Y H:i:s', strtotime($row->mis_punch_date));
      $x->reason =@$row->reason;
      $x->in_out =$in_out;
      $x->apr_by =$empp_name;
          //  $x->out_rem =$dt->out_rem;
           // $x->shift_cd =$dt->shift_cd;
			array_push($datas,$x);
		}
		
		$collection = Collection::make($datas);
		return $collection;
    }


    public function headings(): array{
        $unit_cd = Session::get('unit_cd');
        $unit_name = Session::get('unit_name');
       $unit_code = $unit_cd;
       $unitname = $unit_name;
       return [
               ['Company Name', $unitname],
               ['Unit Code', $unit_code],
               [''],
               ['EMP. Name','EMP. Code','Department','Desigenation','Working Dates','Punch Date-Time','Remarks','Missed Type','Approved By','Approved On']
           ];
    }


   public function startCell(): string{
       return 'A2';
   }
}

?>