<?php

namespace App\Export;
use DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Illuminate\Support\Collection;
use App\Models\hrm\MissPunchModel;
use App\Models\hrm\Emp_Mast_hd;
use Session;
class MyMissPunchDetailExcel implements FromCollection,WithHeadings,WithCustomStartCell
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $emp_id = Session::get('emp_id');
        $fin_year = Session::get('fin_year');
        $unit_cd = Session::get('unit_cd');
        $last_30_day_dt = date('d-M-Y', strtotime('-30 days'));
        $current_dt= date('d-M-Y');
        $current_month= date('m');
        $res=MissPunchModel::where('empmemb_emp_master_emp_number',$emp_id)->whereMonth('mis_punch_date',$current_month)->where('unit_cd',$unit_cd)->orderBy('mis_punch_date','DESC')->get();
     
        // $row_data = DB::select("SELECT hrm.emp_rawdata_insert('$last_30_day_dt','$current_dt',null,null,null,'$unit_cd','$emp_id')");
        // $all_raw_data=$row_data[0]->emp_rawdata_insert;
        // $miss_punch_req= DB::table('emp_mispunch_view')->where('emp_number',$emp_id)->where('unit_cd',$unit_cd)->orderBy('att_date','DESC')->get();
		$datas = [];
		
		foreach($res as $dt){
			$x = new \stdClass();
            $x->emp_name =getEmpName($dt->empmemb_emp_master_emp_number);
            $x->empmemb_emp_master_emp_number =$dt->empmemb_emp_master_emp_number;
            $emp_dept=getEmpDept($dt->empmemb_emp_master_emp_number);
            $name=@$emp_dept->name;
            $x->dept =$name;

            $emp_desig = getEmpDesig($dt->empmemb_emp_master_emp_number);
            $description = @$emp_desig->description;
            $x->description =$description;
            
            $x->app_date =date('d-m-Y', strtotime($dt->app_date));
            $x->mis_punch_date =date('d-m-Y H:i:s', strtotime($dt->mis_punch_date));
			
            $x->out_time =$dt->reason;
            
            if($dt->mis_punch_type=='I'){
                $in_out='IN-Time';
            }elseif($dt->mis_punch_type=='O'){
                $in_out='OUT-Time';
            }elseif($dt->mis_punch_type=='B'){
                $in_out='Both';
            }
            $x->in_out =$in_out;
            $x->apr_by =$dt->apr_by;
            $x->apr_on =getEmpName($dt->apr_by);
           // $x->in_rem =$dt->in_rem;
          //  $x->out_rem =$dt->out_rem;
           // $x->shift_cd =$dt->shift_cd;
			array_push($datas,$x);
		}
		
		$collection = Collection::make($datas);
		return $collection;
    }


    public function headings(): array{
        $unit_cd = Session::get('unit_cd');
        $unit_name = Session::get('unit_name');
       $unit_code = $unit_cd;
       $unitname = $unit_name;
       return [
               ['Company Name', $unitname],
               ['Unit Code', $unit_code],
               [''],
               ['Emp. Name','EMP. Code','Department','Designation','Working Dates','Punch Date Time','Remarks','Missed Type','Approved By', 'Approved on']
           ];
    }


   public function startCell(): string{
       return 'A2';
   }
}

?>