<?php

namespace App\Export;
use DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Illuminate\Support\Collection;
use App\Models\hrm\RoleWiseEmpLov;
use App\Models\hrm\Emp_Mast_hd;
use App\Models\LeaveDetails;
use App\Models\LeaveMaster;
use App\Models\hrm\SumEmpLeaveMastView;
use Session;
class LeaveSummaryExport implements FromCollection,WithHeadings,WithCustomStartCell
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {

       // dd(request()->emp_cd_pdf_excel);
        $emp_id = Session::get('emp_id');
        $fin_year = Session::get('fin_year');
        $unit_cd = Session::get('unit_cd');
         
        $last_30_day_dt = date('d-M-Y', strtotime('-30 days'));
        $current_dt= date('d-M-Y');
         $current_month= date('m');
         
        $reporting_list=RoleWiseEmpLov::where('login_emp',$emp_id)->pluck('emp_number');
        $dept_list_emp=RoleWiseEmpLov::where('login_emp',$emp_id)->where('unit',$unit_cd)->where('area_mast_department_code',request()->dept_no)->pluck('emp_number');
        $lv_check = DB::select("SELECT hrm.gen_emp_leave_mast('$unit_cd','null','$current_dt')");
        $lv_status=$lv_check[0]->gen_emp_leave_mast;

        $db_data=SumEmpLeaveMastView::query();
        $db_data=$db_data->select('sum_emp_leave_mast_view.*','emp_master_hd.emp_first_name','emp_master_hd.emp_last_name','emp_master_hd.area_mast_department_code');
        $db_data=$db_data->join('emp_master_hd','emp_master_hd.emp_number','=','sum_emp_leave_mast_view.empmemb_emp_master_emp_number');
        $db_data=$db_data->where('sum_emp_leave_mast_view.unit_cd',$unit_cd);
        if(request()->year !=''){
            $db_data=$db_data->whereYear('sum_emp_leave_mast_view.start_date',request()->year);
        }
        if(request()->emp_number !=''){
            $db_data=$db_data->where('sum_emp_leave_mast_view.empmemb_emp_master_emp_number',request()->emp_number); 
        }

        if(request()->dept_no !=''){
            $db_data=$db_data->where('emp_master_hd.area_mast_department_code',request()->dept_no); 
        }

        if(request()->leave_type !=''){
            $db_data=$db_data->where('sum_emp_leave_mast_view.leave_desc_leave_desc_type',request()->leave_type); 
        }

        $db_data=$db_data->get();
        $res=  $db_data;
     
         $datas = [];
		
		foreach($res as $row){
            $sum_pending_lv=emp_pendingLv_sum($row->empmemb_emp_master_emp_number,$row->leave_desc_leave_desc_type);
            if($row->leave_desc_leave_desc_type=='LW'){ 
               $total_lv= 0 ;
            }else{
                $total_lv=  $row->curr_year_leave + $row->credit_leave ;
                }

                if($row->leave_desc_leave_desc_type=='LW'){
                   $used_lv=0;
                }else { 
                    $used_lv=$row->leave_availed;
                }

                if($row->leave_desc_leave_desc_type=='LW'){
                    $avail=0;
                   }else{
                    $avail=($row->curr_year_leave + $row->credit_leave)-($row->leave_availed);
                   }
	  $x = new \stdClass();
      $x->empp_name= $row->emp_first_name .' '. $row->emp_last_name ;
      $x->empmemb_emp_master_emp_number =$row->empmemb_emp_master_emp_number;
      $x->leave_type = $row->leave_desc;
      $x->total_leave =$total_lv;
      $x->used_lead =$used_lv;
      $x->avalialbe_leave =$avail;
      $x->department =$row->area_mast_department_code;
      $x->unit =$row->unit_cd;
     
          //  $x->out_rem =$dt->out_rem;
           // $x->shift_cd =$dt->shift_cd;
			array_push($datas,$x);
		}
		
		$collection = Collection::make($datas);
		return $collection;
    }


    public function headings(): array{
        $unit_cd = Session::get('unit_cd');
        $unit_name = Session::get('unit_name');
       $unit_code = $unit_cd;
       $unitname = $unit_name;
       return [
               ['Company Name', $unitname],
               ['Unit Code', $unit_code],
               [''],
               ['EMP. Name','EMP. Code','Leave Type','Total Leave','Used Leave','Available Leave','Department','Unit CD']
           ];
    }


   public function startCell(): string{
       return 'A2';
   }
}

?>