<?php

namespace App\Export;
use DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Illuminate\Support\Collection;
use App\Models\hrm\RoleWiseEmpLov;
use App\Models\hrm\Emp_Mast_hd;
use App\Models\LeaveDetails;
use App\Models\LeaveMaster;
use Session;
class LeaveHistoryExport implements FromCollection,WithHeadings,WithCustomStartCell
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {

       // dd(request()->emp_cd_pdf_excel);
        $emp_id = Session::get('emp_id');
        $fin_year = Session::get('fin_year');
        $unit_cd = Session::get('unit_cd');
         
        $last_30_day_dt = date('d-M-Y', strtotime('-30 days'));
        $current_dt= date('d-M-Y');
         $current_month= date('m');
         
        $reporting_list=RoleWiseEmpLov::where('login_emp',$emp_id)->pluck('emp_number');
        $dept_list_emp=RoleWiseEmpLov::where('login_emp',$emp_id)->where('unit',$unit_cd)->where('area_mast_department_code',request()->dept_no)->pluck('emp_number');
        
        $db_data = LeaveDetails::query();
        if(request()->emp_number !=''){
            $db_data=$db_data->where('empmemb_emp_master_emp_number',request()->emp_number);
        }
          if(request()->year !=''){
            $db_data=$db_data->whereYear('from_date',request()->year);
        }
        if(request()->month !=''){
            $db_data=$db_data->whereMonth('from_date',request()->month);
        }
        if(request()->leave_type !=''){
          $db_data=$db_data->where('leave_desc_leave_desc_type',request()->leave_type);
      }

        if(request()->dept_no !=''){
            $db_data=$db_data->whereIn('empmemb_emp_master_emp_number',$dept_list_emp);
        }
        $db_data=$db_data->whereIn('empmemb_emp_master_emp_number',$reporting_list);
        $db_data=$db_data->where('unit_cd',$unit_cd);
        $db_data=$db_data->orderBy('from_date','DESC');
        $db_data=$db_data->get();
        $res=  $db_data;
        
         $datas = [];
		
		foreach($res as $row){
      $dept_name=getDepartmentNameByEmpCode($row->empmemb_emp_master_emp_number);
			$x = new \stdClass();
      $x->empp_name= getEmpName(@$row->empmemb_emp_master_emp_number);
      $x->empmemb_emp_master_emp_number =$row->empmemb_emp_master_emp_number;
      $x->leave_type = LeaveMaster::where('code',$row->leave_desc_leave_desc_type)->value('description'); ;
      $x->from_date =date('d-m-Y', strtotime($row->from_date));
      $x->end_date =date('d-m-Y', strtotime($row->end_date));
      $x->leave_day =@$row->leave_days;
      $x->applied_date =date('d-m-Y', strtotime($row->app_date));
      $x->applied_to =getEmpName(@$row->dept_head).'('.@$row->dept_head.')';
      $x->department =@$dept_name->name .' ('.@$dept_name->code.')';
      $x->reason =@$row->reason;
      $x->remarks =@$row->remarks;
      if($row->leave_granted=='P'){
        $x->leave_granted ='Pending';
      }elseif($row->leave_granted=='C'){
        $x->leave_granted ='Canceled';
      }elseif($row->leave_granted=='A'){
        $x->leave_granted ='Approved';
      }elseif($row->leave_granted=='R'){
        $x->leave_granted ='Rejected';
      }
          //  $x->out_rem =$dt->out_rem;
           // $x->shift_cd =$dt->shift_cd;
			array_push($datas,$x);
		}
		
		$collection = Collection::make($datas);
		return $collection;
    }


    public function headings(): array{
        $unit_cd = Session::get('unit_cd');
        $unit_name = Session::get('unit_name');
       $unit_code = $unit_cd;
       $unitname = $unit_name;
       return [
               ['Company Name', $unitname],
               ['Unit Code', $unit_code],
               [''],
               ['EMP. Name','EMP. Code','Leave Type','From Date','TO Date','Leave Days','Applied Date','Applied To','Department','Leave Reason','Approve/Reject/Cancel Remarks','Status']
           ];
    }


   public function startCell(): string{
       return 'A2';
   }
}

?>