<?php

namespace App\Export;
use DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Illuminate\Support\Collection;
use App\Models\EmployeeMaster;
use Session;

class EmpMasterExcel implements FromCollection,WithHeadings,WithCustomStartCell
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection(){
        $emp_id = Session::get('emp_id');
        $unit_cd = Session::get('unit_cd');
        $empDetails = EmployeeMaster::orderBy('emp_first_name','asc')->get();       
		$datas = [];		
		foreach($empDetails as $empData){
			$emp = new \stdClass();
			$emp->emp_number =$empData->emp_number;
            $emp->emp_name = @getEmpName($empData->emp_number);
            $emp->date_of_birth = !empty($empData->date_of_birth) ? date('d-m-Y',strtotime($empData->date_of_birth)) : '';
            $emp->card_no = $empData->card_no;
            $emp->sex = ($empData->sex == "M") ? "Male" : "Female";
            $emp->father_name = $empData->father_name;
            $emp->nation_code = @getNationName($empData->nation_code);
            $emp->marital_status = @getMaritalStatus($empData->marital_status);
            $emp->present_phone = $empData->present_phone;
            $emp->permanent_phone = $empData->permanent_phone;
            $emp->company_email = $empData->company_email;
            $emp->per_emailid = $empData->per_emailid;
            $emp->join_date = !empty($empData->join_date) ? date('d-m-Y',strtotime($empData->join_date)) : '';
            $emp->confirm_date = !empty($empData->confirm_date) ? date('d-m-Y',strtotime($empData->confirm_date)) : '';
            $emp->post_till_date = !empty($empData->post_till_date) ? date('d-m-Y',strtotime($empData->post_till_date)) : '';
            $emp->desig_lvl_mast_lvl_mast_level = @getLevelDesc($empData->desig_lvl_mast_lvl_mast_level). " (" .$empData->desig_lvl_mast_lvl_mast_level . ")";
            $emp->category = @getCategoryName($empData->category). " (" .$empData->category . ")";
            $emp->desig_code = @getDesignationName($empData->desig_code). " (" .$empData->desig_code . ")";
            $emp->area_mast_department_code = @getDepartmentName($empData->area_mast_department_code). " (" .$empData->area_mast_department_code . ")";
            $emp->area_cd = @getAreaDesc($empData->area_cd). " (" .$empData->area_cd . ")";
            $emp->status = @getStatus($empData->status);
            $emp->uan_no = $empData->uan_no;
            $emp->adhaar_no = $empData->adhaar_no;
            $emp->pan_no = $empData->pan_no;
            $emp->notice_period_days = $empData->notice_period_days;
            $emp->probation_period_days = $empData->probation_period_days;
            $emp->avg_hr_cost = $empData->avg_hr_cost;
			array_push($datas,$emp);
		}		
		$collection = Collection::make($datas);
		return $collection;
    }

    public function headings(): array{
        $unit_cd = Session::get('unit_cd');
        $unit_name = Session::get('unit_name');
        $unit_code = $unit_cd;
        $unitname = $unit_name;
        return [
                ['Company Name', $unitname],
                ['Unit Code', $unit_code],
                [''],
                ['Emplyoee Code','Employee Name','Date of Birth','Employee Card No','Gender','Father Name','Nationality','Marital Status','Present Phone No','Permanent Phone No','Company Email','Personal Email','Joining Date','Confirmation Date','Relieving Date','Level','Category','Designation','Department','Area','Status','Uan No','Aadhar No','Pan No','Notice Period Days','Probation Period','Average Hrs. Cost']
            ];
    }

   public function startCell(): string{
       return 'A2';
   }
}

?>
