<?php

namespace App\Export;
use DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Illuminate\Support\Collection;
use App\Models\hrm\EmailErrorLogModal;
use Session;

class EmailLogListExcel implements FromCollection,WithHeadings,WithCustomStartCell
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection(){
        $emp_id = Session::get('emp_id');
        $unit_cd = Session::get('unit_cd');
        $db_data = EmailErrorLogModal::query();
        if(request()->mail_date !=''){
            $db_data=$db_data->whereDate('mail_date',request()->mail_date);
        }
        $db_data=$db_data->where('unit_cd',$unit_cd);
        $db_data=$db_data->orderBy('mail_date','DESC');
        $db_data=$db_data->get();
        $data=$db_data;
		$datas = [];		
		foreach($data as $empData){
			$dt = new \stdClass();
            $dt->email_ids = $empData->email_ids;
            $dt->error_description = $empData->error_description;
            $dt->mail_type = $empData->mail_type;
            $dt->mail_date = $empData->mail_date;
            $dt->mail_status = $empData->mail_status;
            $dt->emp_number = $empData->emp_number;
            $dt->unit_cd = $empData->unit_cd;
			array_push($datas,$dt);
		}		
		$collection = Collection::make($datas);
		return $collection;
    }

    public function headings(): array{
        $unit_cd = Session::get('unit_cd');
        $unit_name = Session::get('unit_name');
        $unit_code = $unit_cd;
        $unitname = $unit_name;
        return [
                ['Company Name', $unitname],
                ['Unit Code', $unit_code],
                [''],
                ['Email-Id','Error Desc.','Email Type','Date','Status','Emp Code','Unit Code']
            ];
    }

   public function startCell(): string{
       return 'A2';
   }
}

?>
