<?php

namespace App\Export;
use DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Illuminate\Support\Collection;
use App\Models\hrm\MissPunchModel;
use App\Models\hrm\Emp_Mast_hd;
use Session;
class ApprovalMissPunchExport implements FromCollection,WithHeadings,WithCustomStartCell
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $emp_id = Session::get('emp_id');
        $fin_year = Session::get('fin_year');
        $unit_cd = Session::get('unit_cd');

        $reporting_person=Emp_Mast_hd::select('reporting_to')->where('emp_number',$emp_id)->where('unit',$unit_cd)->first();
        $approval_req=MissPunchModel::get();
		$datas = [];
		
		foreach($approval_req as $dt){
			$x = new \stdClass();
			$x->app_no = $dt->app_no;
			$x->unit_cd = $dt->unit_cd;
			$x->app_date =$dt->app_date;
            $x->empmemb_emp_master_emp_number =$dt->empmemb_emp_master_emp_number;
            $x->emp_name =getEmpName($dt->empmemb_emp_master_emp_number);
            $x->card_no =$dt->card_no;
            $x->dept_head =$dt->dept_head;
			
            $x->mis_punch_date =$dt->mis_punch_date;
            $x->mis_punch_type =$dt->mis_punch_type;
            $x->in_time =$dt->in_time;
            $x->out_time =$dt->out_time;
            $x->reason =$dt->reason;
			array_push($datas,$x);
		}
		
		$collection = Collection::make($datas);
		return $collection;
    }


    public function headings(): array{
        $unit_cd = Session::get('unit_cd');
        $unit_name = Session::get('unit_name');
       $unit_code = $unit_cd;
       $unitname = $unit_name;
       return [
               ['Company Name', $unitname],
               ['Unit Code', $unit_code],
               [''],
               ['Entry No','Unit Code','Entry Date','EMP Code','EMP Name','Card No','Dept Head','Miss Punch Date','Miss Punch Type','In Time','Out Time','Reason']
           ];
    }


   public function startCell(): string{
       return 'A2';
   }
}

?>