<?php

namespace App\Export;
use DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Illuminate\Support\Collection;
use App\Models\hrm\TeamWiseAttendanceView;
use App\Models\hrm\AllTeamAttendanceView;
use App\Models\hrm\Emp_Mast_hd;
use Session;
class AllTeamAttendanceExcel implements FromCollection,WithHeadings,WithCustomStartCell
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {

        
        $emp_id = Session::get('emp_id');
        $fin_year = Session::get('fin_year');
        $unit_cd = Session::get('unit_cd');
        $current_dt= date('d-M-Y');
        $mon = request()->mon;
        $emp_number = request()->emp_number;
        $year = request()->year;

        if(Session::get('search') != null){
            $suspicious_flag = Session::get('search')['suspicious_flag'];
            $att_date = Session::get('search')['setDate'];
            $dept_cd = Session::get('search')['dept_code'];
            if($mon != '' && $emp_number != '' && $year != '')
            {
                if($mon != '' && $emp_number != '' && $year != '' && $suspicious_flag != ''){
                    $teamAttends = AllTeamAttendanceView::where('unit_cd', $unit_cd)->where('dept_code',$dept_cd)->where('emp_number', $emp_number)->where('mon',$mon)->where('yr', $year)->where('suspicious_flag', $suspicious_flag)->get();
                }else{
                    $teamAttends = AllTeamAttendanceView::where('unit_cd', $unit_cd)->where('dept_code',$dept_cd)->where('emp_number', $emp_number)->where('mon',$mon)->where('yr', $year)->get();
                }
            }else if($mon != '' && $att_date != '' && $year != ''){
                if($mon != '' && $att_date != '' && $year != '' && $suspicious_flag != ''){
                    $teamAttends = AllTeamAttendanceView::where('unit_cd', $unit_cd)->where('dept_code',$dept_cd)->where('mon',$mon)->where('yr', $year)->where('att_date',$att_date)->where('suspicious_flag', $suspicious_flag)->get();
                }
                else{
                    $teamAttends = AllTeamAttendanceView::where('unit_cd', $unit_cd)->where('dept_code',$dept_cd)->where('mon',$mon)->where('yr', $year)->where('att_date',$att_date)->get();
                }
            } else if($mon != '' && $suspicious_flag != '' && $year != ''){
                $teamAttends = AllTeamAttendanceView::where('unit_cd', $unit_cd)->where('dept_code',$dept_cd)->where('mon',$mon)->where('yr', $year)->where('suspicious_flag', $suspicious_flag)->get();
            }
            else {
                $teamAttends = AllTeamAttendanceView::where('mon',$mon)->where('yr', $year)->where('unit_cd', $unit_cd)->where('dept_code',$dept_cd)->get();
            }
        }
        else{
            $teamAttends = AllTeamAttendanceView::get();
        }

		$datas = [];
		
		foreach($teamAttends as $dt){
			$x = new \stdClass();

            $inAddress = !empty($dt->in_address) ? str_replace(", Noida, Uttar Pradesh 201301, India","",$dt->in_address) : '';
            //str_replace(", Noida, Uttar Pradesh 201301, India","",$attendances['inAddress'][$j]->address);
            $inAddress = str_replace("WAJIDPUR, SEC.63,","",$inAddress);
            $outAddress = !empty($dt->out_address) ? str_replace(", Noida, Uttar Pradesh 201301, India","",$dt->out_address) : ""; 
            $outAddress = str_replace("WAJIDPUR, SEC.63,","",$outAddress); 

			$x->emp_name = @getEmpName($dt->emp_number);
			$x->emp_number =$dt->emp_number;
            $x->dept_code =@getDepartmentName($dt->dept_code);
            $x->att_date =!empty($dt->att_date) ? date('d-m-Y',strtotime($dt->att_date)) : '';
            $x->in_time =!empty($dt->in_time) ? date('H:i A',strtotime($dt->in_time)) : '';
            $x->in_address = $inAddress;
            $x->in_loc_remarks = $dt->in_loc_remarks;
            $x->out_time =!empty($dt->out_time) ? date('H:i A',strtotime($dt->out_time)) : '';
			$x->out_address = $outAddress;
            $x->out_loc_remarks = $dt->out_loc_remarks;
            $x->totl_hrs = $dt->tot_time;
            $x->suspicious_flag = $dt->suspicious_flag;
			array_push($datas,$x);
		}
		
		$collection = Collection::make($datas);
		return $collection;
    }


    public function headings(): array{
        $unit_cd = Session::get('unit_cd');
        $unit_name = Session::get('unit_name');
        $unit_code = $unit_cd;
        $unitname = $unit_name;
        return [
               ['Company Name', $unitname],
               ['Unit Code', $unit_code],
               [''],
               ['Employee Name','Emplyoee Code','Department','Att date','In Time','In Address','In Remark','Out Time','Out Address','Out Remark','Total Hrs', 'Suspicious']
           ];
    }


   public function startCell(): string{
       return 'A2';
   }
}

?>