<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use  App\Models\Subscription;
use  App\Models\Routing;
use  App\Models\CartPackage;
use  App\Models\Cart;
use  App\Models\SPServiceSettings;
use  App\Models\SPRoutingAlert;
use  App\Models\SPRoutingAlertDetail;
use  App\Models\UserAlert;
use  App\Models\SPAlert;
use  App\Models\SPPayment;
use  App\Models\SPPaymentTransaction;
use  App\Models\SPPaymentHistory;
use  App\Models\SubCategoryServiceRule;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Log;
use DB;
use Validator;
use Illuminate\Contracts\Queue\Queue;

class SPPaymentController extends Controller {
    
    /**
     * This function use for add alert for user.
     *
     * @return Response
     */
    public function addAlert($refrence_id, $alert_type, $sub_type, $sp_id){
        try {
            $SPRoutingAlertdetai = SPRoutingAlertDetail::where('id', $refrence_id)->first();
            $sub_details = Subscription::where('id', $SPRoutingAlertdetai->subscription_id)->with('getCartPackageDetails')->first();
            
            $SPAlerts = new SPAlert();
            $SPAlerts->alert_type = $alert_type;
            $SPAlerts->sub_type = $sub_type;
            $SPAlerts->refrence_id = $refrence_id;
            $SPAlerts->title = @$sub_details->getCartPackageDetails->package_name;
            $SPAlerts->description = @$sub_details->getCartPackageDetails->short_description;
            $SPAlerts->alert_image = @$sub_details->getCartPackageDetails->package_image;
            $SPAlerts->status = 0;
            $SPAlerts->sp_id = $sp_id;
            $SPAlerts->save();
            return true;
        }catch(\Exception $e) {
            return response()->json(['message' => 'Error: '.$e], 500);
        }

    }

    /**
     * This function use for add alert for customer.
     *
     * @return Response
     */
    public function addAlertForCust($refrence_id, $alert_type, $sub_type, $user_id, $title){
        try {
            $UserAlerts = new UserAlert();
            $UserAlerts->refrence_id = $refrence_id;
            $UserAlerts->alert_type = $alert_type;
            $UserAlerts->sub_type = $sub_type;            
            $UserAlerts->title = $title;
            $UserAlerts->create_by = $user_id;
            $UserAlerts->user_id = $user_id;
            $UserAlerts->save();
            return true;
        }catch(\Exception $e) {
            return response()->json(['message' => 'Error: '.$e], 500);
        }

    }

    /**
     * This function use for add payment for sp by subscription.
     *
     * @return Response
     */
    public function addPaymentForSP($sub_id, $r_id, $sp_id, $commission, $create_by){
        $sub_details = Subscription::where('id', $sub_id)->with('getCartPackageDetails')->first();

        $selling_price = $sub_details->getCartPackageDetails->selling_price;
        $amount = $selling_price*$commission/100;

        $SPPayment = new SPPayment();
        $SPPayment->subscription_id = $sub_id;
        $SPPayment->sp_id = $sp_id;
        $SPPayment->amount = $amount;
        $SPPayment->commission = $commission;
        $SPPayment->payment_status = 'pending';
        $SPPayment->create_by = $create_by;
        $SPPayment->save();
        
        return true;
    }
    
    /**
     * This function use for add payment for all yesterday completed subscription.
     *
     * @return Response
     */
    public function addPaymentForCompletedSubs(Request $request){

        DB::beginTransaction();
        try {

            $sub_details = Subscription::where('status', 'Completed')->where('service_date', date('Y-m-d', strtotime("-1 day")))->with('getCartPackageDetails')->with('getcartdetails')->get();
            
            foreach($sub_details as $sub_detail){
                $routing_details = DB::connection('sp_management')->select("SELECT * FROM routing.sp_routing_alert_details WHERE subscription_id IN (".$sub_detail->id.") and status ='CLOSE' LIMIT 1")[0];
                
                $transactions = DB::connection('cart_management')->select("SELECT * FROM cart_management.`transaction` WHERE subscription_id IN (".$sub_detail->id.")");

                $commission = $routing_details->commission;
                $sp_id = $routing_details->provider_id;

                $total_amount = 0;
                foreach($transactions as $transaction){
                    
                    // Add Payment transaction
                    $SPPayment = new SPPaymentTransaction();
                    $SPPayment->subscription_id = $transaction->subscription_id;
                    $SPPayment->sp_id = $sp_id;
                    $SPPayment->amount = $transaction->total;
                    if($transaction->description == 'order'){
                        $SPPayment->commission = $commission;
                        $SPPayment->commission_mount = $transaction->total*$commission/100;
                        $total_amount += $transaction->total*$commission/100;
                    }else{
                        $SPPayment->commission = 100;
                        $total_amount += $transaction->total;
                    }
                    //$SPPayment->payment_status = 'pending';
                    $SPPayment->description = $transaction->description;
                    $SPPayment->create_by = 'Admin';
                    $SPPayment->save();                    
                }
                
                // Add Payment
                $SPPayment = new SPPayment();
                $SPPayment->subscription_id = $sub_detail->id;
                $SPPayment->sp_id = $sp_id;
                $SPPayment->amount = $total_amount;
                $SPPayment->payment_status = 'pending';
                $SPPayment->create_by = 'Admin';
                $SPPayment->save();
                
            }
            DB::commit();
            return true;
        }catch(\Exception $e) {
            DB::rollback();
            return response()->json(['message' => 'error: '.$e], 500);
        }
    }
    
    /**
     * This function use for add sp payment.
     *
     * @return Response
     */
    public function addSPPayment(Request $request){
        $validator = Validator::make($request->all(), [ 
            'subscription_id' => 'required',
            'sp_id' => 'required',
            'transaction_id' => 'required',
            'amount' => 'required',
            'create_by' => 'required'
        ]);
        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }
        
        try {
            $AuthController = new AuthController();
            $token_status = $AuthController->tokenVerify($request);
            
            if(@$token_status['status'] == '200'){

                // Check sp payment availble or not
                $SPPayment = SPPayment::where('subscription_id', $request->subscription_id)->where('sp_id', $request->sp_id)->first();
                
                if($SPPayment->count() > 0){
                    if($SPPayment->payment_status == 'done'){
                        return response()->json(['status' => 0,'message' => 'payment has already been paid!', 'data' => ''], 401);
                    }

                    if($SPPayment->amount != $request->amount){
                        return response()->json(['status' => 0,'message' => 'Payment amount should be same as generated payment: '.$SPPayment->amount, 'data' => ''], 401);
                    }
                }

                // add payment
                $SPPaymentHistory = new SPPaymentHistory();
                $SPPaymentHistory->subscription_id = $request->subscription_id;
                $SPPaymentHistory->sp_id = $request->sp_id;
                $SPPaymentHistory->transaction_id = $request->transaction_id;
                $SPPaymentHistory->amount = $request->amount;
                $SPPaymentHistory->comment = $request->comment;
                $SPPaymentHistory->payment_status = 'done';
                $SPPaymentHistory->create_by = $request->create_by;
                $SPPaymentHistory->payment_date = date('Y-m-d, H:i:s');
                $SPPaymentHistory->save();  
                
                // Update the payment status of sp payment table
                $SPPayment->payment_status = 'done';
                $SPPayment->save();

                return response()->json(['status' => 1,'message' => 'Payment Done!', 'data' => $SPPaymentHistory], 200);
            }else{
                return response()->json(['status' => 0, 'error' => 1,'message' => 'unexpected signing method in auth token'], 500);
            }

        }catch(\Exception $e) {
            return response()->json(['message' => 'Error: '.$e], 500);
        }

    }
    
    /**
     * This function use for get sp payments.
     *
     * @return Response
     */
    public function getSPPayments(Request $request){
        
        try {
            $AuthController = new AuthController();
            $token_status = $AuthController->tokenVerify($request);
            
            if(@$token_status['status'] == '200'){

                // Check sp payment availble or not
                $SPPayment = SPPayment::with('getSubscriptionDetails')->get();

                return response()->json(['status' => 1,'message' => 'SP Payments!', 'data' => $SPPayment], 200);
            }else{
                return response()->json(['status' => 0, 'error' => 1,'message' => 'unexpected signing method in auth token'], 500);
            }

        }catch(\Exception $e) {
            return response()->json(['message' => 'Error: '.$e], 500);
        }

    }

    /**
     * This function use for get sp payments.
     *
     * @return Response
     */
    public function getSPPaymentDetail(Request $request){
        $validator = Validator::make($request->all(), [ 
            'payment_id' => 'required',
        ]);
        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }
        try {
            $AuthController = new AuthController();
            $token_status = $AuthController->tokenVerify($request);
            
            if(@$token_status['status'] == '200'){

                // Check sp payment availble or not
                $SPPayment = SPPayment::where('id', $request->payment_id)->with('getPaymentTransaction')->first();

                return response()->json(['status' => 1,'message' => 'SP Payments!', 'data' => $SPPayment], 200);
            }else{
                return response()->json(['status' => 0, 'error' => 1,'message' => 'unexpected signing method in auth token'], 500);
            }

        }catch(\Exception $e) {
            return response()->json(['message' => 'Error: '.$e], 500);
        }

    }
    
    /**
     * This function use for get sp payments receive details.
     *
     * @return Response
     */
    public function getSPPaymentReceive(Request $request){
        $validator = Validator::make($request->all(), [ 
            'sub_id' => 'required',
        ]);
        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }
        try {
            $AuthController = new AuthController();
            $token_status = $AuthController->tokenVerify($request);
            
            if(@$token_status['status'] == '200'){

                // Check sp payment availble or not
                $SPPaymentHistory = SPPaymentHistory::where('subscription_id', $request->sub_id)->first();

                return response()->json(['status' => 1,'message' => 'SP Payments Transaction!', 'data' => $SPPaymentHistory], 200);
            }else{
                return response()->json(['status' => 0, 'error' => 1,'message' => 'unexpected signing method in auth token'], 500);
            }

        }catch(\Exception $e) {
            return response()->json(['message' => 'Error: '.$e], 500);
        }

    }
    
    
    /**
     * This function use for get sp payments for sp dashboard.
     *
     * @return Response
     */
    public function getSPPaymentsForSPDas(Request $request){
        $validator = Validator::make($request->all(), [ 
            'sp_id' => 'required',
        ]);

        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }

        try {
            $AuthController = new AuthController();
            $token_status = $AuthController->tokenVerify($request);
            
            if(@$token_status['status'] == '200'){

                // Check sp payment availble or not 
                $SPPayment = SPPayment::where('sp_id', $request->sp_id)->with('getSubscriptionDetails')->get();

                return response()->json(['status' => 1,'message' => 'SP Payments!', 'data' => $SPPayment], 200);
            }else{
                return response()->json(['status' => 0, 'error' => 1,'message' => 'unexpected signing method in auth token'], 500);
            }

        }catch(\Exception $e) {
            return response()->json(['message' => 'Error: '.$e], 500);
        }

    }
    
    /**
     * This function use for get sp payments for sp dashboard.
     *
     * @return Response
     */
    public function getPaymentDetailForSPDas(Request $request){
        $validator = Validator::make($request->all(), [ 
            'sp_id' => 'required',
            'payment_id' => 'required',
        ]);
        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }
        try {
            $AuthController = new AuthController();
            $token_status = $AuthController->tokenVerify($request);
            
            if(@$token_status['status'] == '200'){

                // Check sp payment availble or not
                $SPPayment = SPPayment::where('id', $request->payment_id)->where('sp_id', $request->sp_id)->with('getPaymentTransaction')->first();

                return response()->json(['status' => 1,'message' => 'SP Payments!', 'data' => $SPPayment], 200);
            }else{
                return response()->json(['status' => 0, 'error' => 1,'message' => 'unexpected signing method in auth token'], 500);
            }

        }catch(\Exception $e) {
            return response()->json(['message' => 'Error: '.$e], 500);
        }

    }
    
    /**
     * This function use for get sp payments receive details for sp dashboard.
     *
     * @return Response
     */
    public function getPaymentReceiveForSPDas(Request $request){
        $validator = Validator::make($request->all(), [ 
            'sp_id' => 'required',
            'sub_id' => 'required',
        ]);
        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }
        try {
            $AuthController = new AuthController();
            $token_status = $AuthController->tokenVerify($request);
            
            if(@$token_status['status'] == '200'){

                // Check sp payment availble or not
                $SPPaymentHistory = SPPaymentHistory::where('subscription_id', $request->sub_id)->where('sp_id', $request->sp_id)->first();

                return response()->json(['status' => 1,'message' => 'SP Payments Transaction!', 'data' => $SPPaymentHistory], 200);
            }else{
                return response()->json(['status' => 0, 'error' => 1,'message' => 'unexpected signing method in auth token'], 500);
            }

        }catch(\Exception $e) {
            return response()->json(['message' => 'Error: '.$e], 500);
        }

    }
    
    
}