<?php

/** @var \Laravel\Lumen\Routing\Router $router */

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->get('/', function () use ($router) {
    return $router->app->version();
});

$router->group(['prefix' => 'api'], function () use ($router) {

    // Add payment for yesterday completed subscription
    $router->get('addpaymentcompletedsubscription', 'SPPaymentController@addPaymentForCompletedSubs');

    // Add payment for SP
    $router->post('addpayment', 'SPPaymentController@addSPPayment');
    
    // Get SP Payments
    $router->get('getsppayments', 'SPPaymentController@getSPPayments');

    // Get payment transactions
    $router->get('getsppaymenttransaction', 'SPPaymentController@getSPPaymentDetail');
    
    // Get payment receive transaction
    $router->get('getreceivepaymenttransaction', 'SPPaymentController@getSPPaymentReceive');
    
    // For SP Dashboard
    $router->get('getpaymentsforsp', 'SPPaymentController@getSPPaymentsForSPDas');
    $router->get('getpaymentdetailsforsp', 'SPPaymentController@getPaymentDetailForSPDas');
    $router->get('getreceivepaymentforsp', 'SPPaymentController@getPaymentReceiveForSPDas');
    
    
    // Token Verify
    $router->post('tokenverify', 'AuthController@tokenVerify');
});
