<?php

namespace App\Jobs;

use App\Http\Controllers\FCMMessageController;
use DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Http;
use  App\Models\SPDetails;
use Illuminate\Http\Request;

class PushNotification extends Job
{
    //use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $sp_id;
    protected $title;
    protected $des;
    public function __construct($sp_id, $title, $des)
    {
        $this->sp_id = $sp_id;
        $this->title = $title;
        $this->des = $des;
    }


    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        
        $title = $this->title;
        $des = $this->des;
        $spdetails = SPDetails::where('id', $this->sp_id)->first();
        $fcm_token = $spdetails->device_token;

        // Send FCM
        $fcm = new FCMMessageController();
        return $fcm->sendMessage($fcm_token, $title, $des);

    }
}
