<?php

namespace App\Services;

use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;

class FirebaseNotificationService
{
    public $messaging;

    public function __construct()
    {
        // Load Firebase configuration
        $factory = (new Factory)
            ->withServiceAccount(__DIR__.'/clykk-firebase.json');

        // Get Messaging instance
        $this->messaging = $factory->createMessaging();
    }

    public function sendNotification($deviceToken, $title, $body)
    {
        //$deviceToken = 'cuqP5Tn5RkOfwc2SsFs18f:APA91bGYEQY8i1Eiu0lHyLky8ntVrNolWkXIV_F1hA_aTLzEmyJYYDvc6-ik2nK7w7NGK0aus3d6W90MehHUPQgm8iXz0FvgXBVSEwJx8bm0VEESegYXURc';
        $notification = Notification::create($title, $body);

        $message = CloudMessage::withTarget('token', $deviceToken)
            ->withNotification($notification)
            ->withData(['custom_data' => 'value']); // Optional data payload

        // Send the message
        $this->messaging->send($message);
    }
}
