<?php

namespace App\Models;

use Illuminate\Auth\Authenticatable;
use Illuminate\Contracts\Auth\Access\Authorizable as AuthorizableContract;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Laravel\Lumen\Auth\Authorizable;

use Tymon\JWTAuth\Contracts\JWTSubject;

class DocumentByCategory extends Model
{

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'category_id','city_id','referer','document_name','enabled','created_at','updated_at',
    ];

    protected $connection = 'sp_management';
    protected $table = 'document_by_category'; 
    
    // Get document details
    public function documentStatus(){
        return $this->hasOne(DocumentReceived::class, 'document_id','id')->where('referer','sp');
    }


    
}