<?php

namespace App\Http\Controllers;


use sngrl\PhpFirebaseCloudMessaging\Client;
use sngrl\PhpFirebaseCloudMessaging\Message;
use sngrl\PhpFirebaseCloudMessaging\Recipient\Device;
use sngrl\PhpFirebaseCloudMessaging\Notification;


class FCMMessageController extends Controller {


    // Send FCM
    public function sendMessage($device_key, $title, $description){
        $server_key = env('FCM_APP_SECRET');
        $client = new Client();
        $client->setApiKey($server_key);
        $client->injectGuzzleHttpClient(new \GuzzleHttp\Client());

        $message = new Message();
        $message->setPriority('high');
        $message->addRecipient(new Device($device_key));
        $message
            ->setNotification(new Notification($title, $description));
        $response = $client->send($message);
        return $response->getBody()->getContents();
    }
    
}
