<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use  App\Models\UserAlerts;
use  App\Http\Controllers\AuthController;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Validator;

class UserAlertController extends Controller {
    

    /**
     * This function use for add alert for user.
     *
     * @return Response
     */
    public function addAlert(Request $request){
        try {
            $AuthController = new AuthController();
            $token_status = $AuthController->tokenVerify($request);
                        
            if($token_status['status'] == '200'){
                $user = $AuthController->getUserInfo($request);
                
                $UserAlerts = new UserAlerts();
                $UserAlerts->alert_type = $request->alert_type;
                $UserAlerts->sub_type = $request->sub_type;
                $UserAlerts->refrence_id = $request->refrence_id;
                $UserAlerts->title = $request->title;
                $UserAlerts->description = $request->description;
                $UserAlerts->alert_image = $request->alert_image;
                $UserAlerts->status = $request->status;
                $UserAlerts->create_by = $user['data']['userId'];
                $UserAlerts->user_id = $user['data']['userId'];
                $UserAlerts->save();
                return response()->json(['error' => 0,'message' => 'Alert save successfull!', 'data' => $UserAlerts], 200);
            }else{
                return response()->json(['error' => 1,'message' => 'unexpected signing method in auth token'], 500);
            }

        }catch(\Exception $e) {
            return response()->json(['message' => 'Error: '.$e], 500);
        }

    }

    /**
     * This function use for get alert for user.
     *
     * @return Response
     */
    public function getUserAlerts(Request $request){
        
        try {
            $AuthController = new AuthController();
            $token_status = $AuthController->tokenVerify($request);
            
            
            if($token_status['status'] == '200'){
                if($request->has('alert_type')){
                    $UserAlerts = UserAlerts::where('user_id', $request->user_id)->where('alert_type', $request->alert_type)->orderBy('id', 'DESC')->get();
                    if($request->has('before_day')){
                        $current = Carbon::now();
                        $today = $current->toDateString();
                        $from_date = $current->subDay($request->before_day)->toDateString();
                        \DB::enableQueryLog();
                        $UserAlerts = UserAlerts::where('user_id', $request->user_id)->where('alert_type', $request->alert_type)->whereBetween('created_at',[$from_date, $today])->orderBy('id', 'DESC')->get();
                       //dd(\DB::getQueryLog());
                    }
                }else{
                    $UserAlerts = UserAlerts::where('user_id', $request->user_id)->orderBy('id', 'DESC')->limit(10)->get();
                }
                
                return response()->json(['error' => 0,'message' => 'User alerts is here!', 'data' => $UserAlerts], 200);
            }else{
                return response()->json(['error' => 1,'message' => 'unexpected signing method in auth token'], 500);
            }

        }catch(\Exception $e) {
            return response()->json(['message' => 'Error: '.$e], 500);
        }

    }

    /**
     * This function use for update alert for user.
     *
     * @return Response
     */
    public function updateAlert(Request $request){
        
        try {
            $AuthController = new AuthController();
            $token_status = $AuthController->tokenVerify($request);
                        
            if($token_status['status'] == '200'){
                $UserAlerts = UserAlerts::where('id', $request->id)->first();
                $UserAlerts->status = $request->status;
                $UserAlerts->save();
                return response()->json(['error' => 0,'message' => 'Alert save successfull!', 'data' => $UserAlerts], 200);
            }else{
                return response()->json(['error' => 1,'message' => 'unexpected signing method in auth token'], 500);
            }

        }catch(\Exception $e) {
            return response()->json(['message' => 'error: '.$e], 500);
        }

    }

    /**
     * This function use for get alert count only unread.
     *
     * @return Response
     */
    public function getUserAlertsCount(Request $request){
        
        try {
            $AuthController = new AuthController();
            $token_status = $AuthController->tokenVerify($request);
            
            if($token_status['status'] == '200'){
                $UserAlerts = UserAlerts::where('user_id', $request->user_id)->where('status', '!=', '2')->count();
                
                return response()->json(['error' => 0,'message' => 'User total unread alerts count here!', 'count' => $UserAlerts], 200);
            }else{
                return response()->json(['error' => 1,'message' => 'unexpected signing method in auth token'], 500);
            }

        }catch(\Exception $e) {
            return response()->json(['message' => 'error: '.$e], 500);
        }

    }
    
    /**
     * This function use for delete alert for user.
     *
     * @return Response
     */
    public function deleteAlert(Request $request){
        $validator = Validator::make($request->all(), [ 
            'alert_id' => 'required',
            'user_id' => 'required'
        ]);
        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }

        try {
            $AuthController = new AuthController();
            $token_status = $AuthController->tokenVerify($request);
                        
            if($token_status['status'] == '200'){
                UserAlerts::where('id', $request->alert_id)->delete();
                $UserAlerts = UserAlerts::where('user_id', $request->user_id)->orderBy('id', 'DESC')->get();
                return response()->json(['error' => 0,'message' => 'Alert delete successfull!', 'data' => $UserAlerts], 200);
            }else{
                return response()->json(['error' => 1,'message' => 'unexpected signing method in auth token'], 500);
            }

        }catch(\Exception $e) {
            return response()->json(['message' => 'error: '.$e], 500);
        }

    }

}