<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use  App\Models\SPAlerts;
use  App\Http\Controllers\AuthController;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Validator;

class SPAlertController extends Controller {
    

    /**
     * This function use for add alert for user.
     *
     * @return Response
     */
    public function addAlert(Request $request){
        try {
            $AuthController = new AuthController();
            $token_status = $AuthController->tokenVerify($request);
                        
            if($token_status['status'] == '200'){
                $user = $AuthController->getUserInfo($request);
                
                $SPAlerts = new SPAlerts();
                $SPAlerts->alert_type = $request->alert_type;
                $SPAlerts->sub_type = $request->sub_type;
                $SPAlerts->refrence_id = $request->refrence_id;
                $SPAlerts->title = $request->title;
                $SPAlerts->description = $request->description;
                $SPAlerts->alert_image = $request->alert_image;
                $SPAlerts->status = $request->status;
                $SPAlerts->create_by = $user['data']['userId'];
                $SPAlerts->sp_id = $user['data']['userId'];
                $SPAlerts->save();
                return response()->json(['error' => 0,'message' => 'Alert save successfull!', 'data' => $SPAlerts], 200);
            }else{
                return response()->json(['error' => 1,'message' => 'Unauthorized auth token'], 401);
            }

        }catch(\Exception $e) {
            return response()->json(['message' => 'Error: '.$e], 500);
        }

    }

    /**
     * This function use for get alert for user.
     *
     * @return Response
     */
    public function getSPAlerts(Request $request){
        
        try {
            $AuthController = new AuthController();
            $token_status = $AuthController->tokenVerify($request);
            
            
            if($token_status['status'] == '200'){
                if($request->has('alert_type')){
                    $SPAlerts = SPAlerts::where('sp_id', $request->sp_id)->where('alert_type', $request->alert_type)->orderBy('id', 'DESC')->get();
                    if($request->has('before_day')){
                        $current = Carbon::now();
                        $today = $current->toDateString();
                        $from_date = $current->subDay($request->before_day)->toDateString();
                        \DB::enableQueryLog();
                        $SPAlerts = SPAlerts::where('sp_id', $request->sp_id)->where('alert_type', $request->alert_type)->whereBetween('created_at',[$from_date, $today])->orderBy('id', 'DESC')->get();
                       //dd(\DB::getQueryLog());
                    }
                }else{
                    $SPAlerts = SPAlerts::where('sp_id', $request->sp_id)->orderBy('id', 'DESC')->limit(10)->get();
                }
                
                return response()->json(['error' => 0,'message' => 'SP alerts is here!', 'data' => $SPAlerts], 200);
            }else{
                return response()->json(['error' => 1,'message' => 'Unauthorized auth token'], 401);
            }

        }catch(\Exception $e) {
            return response()->json(['message' => 'Error: '.$e], 500);
        }

    }

    /**
     * This function use for update alert for user.
     *
     * @return Response
     */
    public function updateAlert(Request $request){
        
        try {
            $AuthController = new AuthController();
            $token_status = $AuthController->tokenVerify($request);
                        
            if($token_status['status'] == '200'){
                $SPAlerts = SPAlerts::where('id', $request->id)->first();
                $SPAlerts->status = $request->status;
                $SPAlerts->save();
                return response()->json(['error' => 0,'message' => 'Alert save successfull!', 'data' => $SPAlerts], 200);
            }else{
                return response()->json(['error' => 1,'message' => 'Unauthorized auth token'], 401);
            }

        }catch(\Exception $e) {
            return response()->json(['message' => 'error: '.$e], 500);
        }

    }

    /**
     * This function use for get alert count only unread.
     *
     * @return Response
     */
    public function getSPAlertsCount(Request $request){
        
        try {
            $AuthController = new AuthController();
            $token_status = $AuthController->tokenVerify($request);
            
            if($token_status['status'] == '200'){
                $SPAlerts = SPAlerts::where('sp_id', $request->sp_id)->where('status', '!=', '2')->count();
                
                return response()->json(['error' => 0,'message' => 'SP total unread alerts count here!', 'count' => $SPAlerts], 200);
            }else{
                return response()->json(['error' => 1,'message' => 'Unauthorized auth token'], 401);
            }

        }catch(\Exception $e) {
            return response()->json(['message' => 'error: '.$e], 500);
        }

    }


    /**
     * This function use for delete alert for sp.
     *
     * @return Response
     */
    public function deleteAlert(Request $request){
        $validator = Validator::make($request->all(), [ 
            'alert_id' => 'required',
            'sp_id' => 'required'
        ]);
        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }

        try {
            $AuthController = new AuthController();
            $token_status = $AuthController->tokenVerify($request);
                        
            if($token_status['status'] == '200'){
                SPAlerts::where('id', $request->alert_id)->delete();
                $SPAlerts = SPAlerts::where('sp_id', $request->sp_id)->orderBy('id', 'DESC')->get();
                return response()->json(['error' => 0,'message' => 'Alert delete successfull!', 'data' => $SPAlerts], 200);
            }else{
                return response()->json(['error' => 1,'message' => 'Unauthorized auth token'], 401);
            }

        }catch(\Exception $e) {
            return response()->json(['message' => 'error: '.$e], 500);
        }

    }

}