<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use  App\Models\User;

class UserController extends Controller
{
    /**
     * Instantiate a new UserController instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Get the authenticated User.
     *
     * @return Response
     */
    public function profile(){ 
		$loguser = Auth::user();
		$user = User::where('admin_id', $loguser->admin_id)->with('getUserRole')->first();
		
        return response()->json(['user' => $user], 200);
    }

    /**
     * Get all User.
     *
     * @return Response
     */
    public function allUsers()
    {
         return response()->json(['users' =>  User::with('getUserRole')->get()], 200);
    }
	
	/**
     * Active User.
     *
     * @return Response
     */
    public function activeUser($id){
		$user = User::where('admin_id', $id)->first();
		$user->enabled = 1;
        $user->save();
		return response()->json(['users' =>  User::all()], 200);
    } 
	
	/**
     * Inactive User.
     *
     * @return Response
     */
    public function inactiveUser($id){
        $user = User::where('admin_id', $id)->first();
		$user->enabled = 0;
        $user->save();
		return response()->json(['users' =>  User::all()], 200);
    }
	
	/**
     * Store a new user.
     *
     * @param  Request  $request
     * @return Response
     */
    public function updateUser(Request $request)
    {
        
        //validate incoming request 
        $this->validate($request, [
            'user_id' => 'required',
            'fname' => 'required|string',
            'lname' => 'required|string',
            'email' => 'required|email|unique:admins,email,'.$request->user_id.',admin_id',
            'mobile' => 'required|unique:admins,mobile,'.$request->user_id.',admin_id',
        ]);

        try {
            
            $user = User::where('admin_id', $request->user_id)->first();
			if(!$user){
				return response()->json(['user' => '', 'message' => 'User Not Found'], 201);
			}
            $user->first_name = $request->input('fname');
            $user->last_name = $request->input('lname');
            $user->email = $request->input('email');
            $user->mobile = $request->input('mobile');
            $user->updated_by = $request->input('updated_by');

            $user->save();

            //return successful response
            return response()->json(['user' => $user, 'message' => 'User Updated Successfull'], 200);

        } catch (\Exception $e) {
            //return error message
            return response()->json(['message' => 'User Registration Failed!'], 409);
        }

    }

    /**
     * Get one user.
     *
     * @return Response
     */
    public function singleUser($id)
    {
        try {
            $user = User::findOrFail($id);

            return response()->json(['user' => $user], 200);

        } catch (\Exception $e) {

            return response()->json(['message' => 'user not found!'], 404);
        }

    }

}