<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Validator;
use  App\Models\User;
use  App\Models\Role;

class RoleController extends Controller
{
    /**
     * Instantiate a new UserController instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * This function use for create the role
     *
     * @return Response
     */
    public function addRole(Request $request){
        $validator = Validator::make($request->all(), [ 
            'role_name' => 'required',
        ]);
        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }
        $user = Auth::user();

        $Role = new Role();
        $Role->role_name = $request->role_name;
        $Role->created_by = $user->admin_id;
        $Role->updated_by = $user->admin_id;
        $Role->save(); 
        
        return response()->json(['data' => $Role, 'status' => 'success'], 200);
    }

    
    /**
     * This function use for update the role
     *
     * @return Response
     */
    public function updateRole(Request $request, $id){
        $validator = Validator::make($request->all(), [ 
            'role_name' => 'required',
        ]);
        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }

        $user = Auth::user();
        $Role = Role::where('role_id', $id)->first();
        $Role->role_name = $request->role_name;
        $Role->updated_by = $user->admin_id;
        $Role->save();
        
        return response()->json(['data' => $Role, 'status' => 'success'], 200);
    }

    /**
     * This function use for delete the role
     *
     * @return Response
     */
    public function inactiveRole($id){
        $Role = Role::where('role_id', $id)->first();
		$Role->enabled = 0;
        $Role->save();
		return response()->json(['users' =>  Role::all()], 200);
    }
	
	/**
     * This function use for delete the role
     *
     * @return Response
     */
    public function activeRole($id){
        $Role = Role::where('role_id', $id)->first();
		$Role->enabled = 1;
        $Role->save();
		return response()->json(['users' =>  Role::all()], 200);
    }

    /**
     * This function use for get the role
     *
     * @return Response
     */
    public function getRole($id){
        
        $Role = Role::where('role_id', $id)->first();
        
        return response()->json(['data' => $Role, 'status' => 'success'], 200);
    }

    /**
     * This function use for get all roles
     *
     * @return Response
     */
    public function getRoles(){
        
        $Roles = Role::All();
        
        return response()->json(['data' => $Roles, 'status' => 'success'], 200);
    }

}