<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Validator;
use  App\Models\User;
use  App\Models\Privilege;

class PrivilegeController extends Controller
{
     /**
     * Instantiate a new UserController instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * This function use for create the Privilege
     *
     * @return Response
     */
    public function addPrivilege(Request $request){
        $validator = Validator::make($request->all(), [ 
            'name' => 'required',
        ]);
        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }
        $user = Auth::user();

        $Privilege = new Privilege();
        $Privilege->name = $request->name;
        $Privilege->created_by = $user->admin_id;
        $Privilege->updated_by = $user->admin_id;
        $Privilege->save();
        
        return response()->json(['data' => $Privilege, 'status' => 'success'], 200);
    }

    
    /**
     * This function use for update the Privilege
     *
     * @return Response
     */
    public function updatePrivilege(Request $request, $id){
        $validator = Validator::make($request->all(), [ 
            'name' => 'required',
        ]);
        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }

        $user = Auth::user();
        $Privilege = Privilege::where('privilege_id', $id)->first();
        $Privilege->name = $request->name;
        $Privilege->updated_by = $user->admin_id;
        $Privilege->save();
        
        return response()->json(['data' => $Privilege, 'status' => 'success'], 200);
    }

    /**
     * This function use for delete the Privilege
     *
     * @return Response
     */
    public function deletePrivilege($id){
        
        Privilege::where('privilege_id', $id)->delete();
        $Privilege = Privilege::All();
        return response()->json(['data' => $Privilege, 'status' => 'success'], 200);
    }

    /**
     * This function use for get the Privilege
     *
     * @return Response
     */
    public function getPrivilege($id){
        
        $Privilege = Privilege::where('privilege_id', $id)->first();
        
        return response()->json(['data' => $Privilege, 'status' => 'success'], 200);
    }

    /**
     * This function use for get all Privilege
     *
     * @return Response
     */
    public function getPrivileges(){
        
        $Privileges = Privilege::All();
        
        return response()->json(['data' => $Privileges, 'status' => 'success'], 200);
    }

}