<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Validator;
use App\Models\User;
use App\Models\Modules;

class ModuleController extends Controller
{
    /**
     * Instantiate a new UserController instance. 
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * This function use for create the module
     *
     * @return Response
     */
    public function addModule(Request $request){
        $validator = Validator::make($request->all(), [ 
            'module_name' => 'required',
            'description' => 'required',
        ]); 
        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }
        $user = Auth::user();
        $Modules = new Modules();
        $Modules->module_name = $request->module_name;
        $Modules->description = $request->description;
        $Modules->created_by = $user->admin_id;
        $Modules->updated_by = $user->admin_id;
        $Modules->save();
        
        return response()->json(['data' => $Modules, 'status' => 'success'], 200);
    }

    
    /**
     * This function use for update the module
     *
     * @return Response
     */
    public function updateModule(Request $request, $id){
        $validator = Validator::make($request->all(), [ 
            'module_name' => 'required',
            'description' => 'required',
        ]);
        if ($validator->fails()) { 
            $result = ['type'=>'error', 'message'=>$validator->errors()->all()];
            return response()->json($result);            
        }
        $user = Auth::user();
        $Modules = Modules::where('module_id', $id)->first();
        $Modules->module_name = $request->module_name;
        $Modules->description = $request->description;
        $Modules->updated_by = $user->admin_id;
        $Modules->save();
        
        return response()->json(['data' => $Modules, 'status' => 'success'], 200);
    }

	/**
     * This function use for delete the Module
     *
     * @return Response
     */
    public function inactiveModule($id){
		$Modules = Modules::where('module_id', $id)->first();
		$Modules->enabled = 0;
        $Modules->save();
		return response()->json(['users' =>  Modules::all()], 200);
    }
	
	/**
     * This function use for delete the Module
     *
     * @return Response
     */
    public function activeModule($id){
        $Modules = Modules::where('module_id', $id)->first();
		$Modules->enabled = 1;
        $Modules->save();
		return response()->json(['users' =>  Modules::all()], 200);
    }

    /**
     * This function use for get the module
     *
     * @return Response
     */
    public function getModule($id){
        
        $Modules = Modules::where('module_id', $id)->first();
        
        return response()->json(['data' => $Modules, 'status' => 'success'], 200);
    }

    /**
     * This function use for get all modules
     *
     * @return Response
     */
    public function getModules(){
        $Modules = Modules::All();
        
        return response()->json(['data' => $Modules, 'status' => 'success'], 200);
    }

}